/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.count.CountRequest;
import com.flipkart.foxtrot.common.count.CountResponse;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CountActionTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getCountDocuments(CountActionTest.getMapper());
        CountActionTest.getQueryStore().save("test-table", documents);
        CountActionTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test
    public void testCount() throws FoxtrotException {
        CountRequest countRequest = new CountRequest();
        countRequest.setTable("test-table");
        countRequest.setField("os");
        countRequest.setDistinct(false);
        CountResponse countResponse = (CountResponse)CountResponse.class.cast(CountActionTest.getQueryExecutor().execute((ActionRequest)countRequest));
        Assert.assertNotNull((Object)countResponse);
        Assert.assertEquals((long)11L, (long)countResponse.getCount());
    }

    @Test
    public void testCountWithFilter() throws FoxtrotException {
        CountRequest countRequest = new CountRequest();
        countRequest.setTable("test-table");
        countRequest.setField("os");
        ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
        filters.add(new EqualsFilter("os", (Object)"android"));
        countRequest.setFilters(filters);
        countRequest.setDistinct(false);
        CountResponse countResponse = (CountResponse)CountResponse.class.cast(CountActionTest.getQueryExecutor().execute((ActionRequest)countRequest));
        Assert.assertNotNull((Object)countResponse);
        Assert.assertEquals((long)7L, (long)countResponse.getCount());
    }

    @Test
    public void testCountDistinct() throws FoxtrotException {
        CountRequest countRequest = new CountRequest();
        countRequest.setTable("test-table");
        countRequest.setField("os");
        countRequest.setDistinct(true);
        CountResponse countResponse = (CountResponse)CountResponse.class.cast(CountActionTest.getQueryExecutor().execute((ActionRequest)countRequest));
        Assert.assertNotNull((Object)countResponse);
        Assert.assertEquals((long)2L, (long)countResponse.getCount());
    }

    @Test
    public void testCountDistinctWithFilter() throws FoxtrotException {
        CountRequest countRequest = new CountRequest();
        countRequest.setTable("test-table");
        countRequest.setField("os");
        ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
        filters.add(new EqualsFilter("device", (Object)"nexus"));
        countRequest.setFilters(filters);
        countRequest.setDistinct(true);
        CountResponse countResponse = (CountResponse)CountResponse.class.cast(CountActionTest.getQueryExecutor().execute((ActionRequest)countRequest));
        Assert.assertNotNull((Object)countResponse);
        Assert.assertEquals((long)2L, (long)countResponse.getCount());
    }

    @Test
    public void testCountDistinctWithFilterOnSameField() throws FoxtrotException {
        CountRequest countRequest = new CountRequest();
        countRequest.setTable("test-table");
        countRequest.setField("os");
        ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
        filters.add(new EqualsFilter("os", (Object)"android"));
        countRequest.setFilters(filters);
        countRequest.setDistinct(true);
        CountResponse countResponse = (CountResponse)CountResponse.class.cast(CountActionTest.getQueryExecutor().execute((ActionRequest)countRequest));
        Assert.assertNotNull((Object)countResponse);
        Assert.assertEquals((long)1L, (long)countResponse.getCount());
    }
}

