/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.histogram.HistogramRequest;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CacheHitTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getHistogramDocuments(CacheHitTest.getMapper());
        CacheHitTest.getQueryStore().save("test-table", documents);
        CacheHitTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
        CacheHitTest.getCacheManager().create("histogram");
    }

    @Test
    public void checkCacheability() throws FoxtrotException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.days);
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{greaterThanFilter, lessThanFilter}));
        Assert.assertFalse((boolean)CacheHitTest.getQueryExecutor().execute((ActionRequest)histogramRequest).isFromCache());
        Assert.assertTrue((boolean)CacheHitTest.getQueryExecutor().execute((ActionRequest)histogramRequest).isFromCache());
    }
}

