/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.datastore.impl.hbase;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.DocumentMetadata;
import com.flipkart.foxtrot.core.MockHTable;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HBaseDataStore;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseConfig;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseTableConnection;
import com.flipkart.foxtrot.core.exception.BadRequestException;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.StoreConnectionException;
import com.foxtrot.flipkart.translator.DocumentTranslator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HBaseDataStoreTest {
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"d");
    private static final byte[] DATA_FIELD_NAME = Bytes.toBytes((String)"data");
    private static final com.flipkart.foxtrot.common.Table TEST_APP = com.flipkart.foxtrot.common.Table.builder().name("test-table").ttl(7).build();
    private HBaseDataStore hbaseDataStore;
    private Table tableInterface;
    private HbaseTableConnection hbaseTableConnection;
    private ObjectMapper mapper = new ObjectMapper();

    @Before
    public void setUp() throws Exception {
        this.tableInterface = MockHTable.create();
        this.tableInterface = (Table)Mockito.spy((Object)this.tableInterface);
        this.hbaseTableConnection = (HbaseTableConnection)Mockito.mock(HbaseTableConnection.class);
        Mockito.when((Object)this.hbaseTableConnection.getTable((com.flipkart.foxtrot.common.Table)Matchers.any())).thenReturn((Object)this.tableInterface);
        Mockito.when((Object)this.hbaseTableConnection.getHbaseConfig()).thenReturn((Object)new HbaseConfig());
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV1()));
    }

    @Test
    public void testSaveSingle() throws Exception {
        DocumentTranslator documentTranslator = new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV1());
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, documentTranslator);
        Document expectedDocument = new Document();
        expectedDocument.setId(UUID.randomUUID().toString());
        expectedDocument.setTimestamp(System.currentTimeMillis());
        JsonNode data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        expectedDocument.setData(data);
        this.hbaseDataStore.save(TEST_APP, expectedDocument);
        this.validateSave(this.v1FormatKey(expectedDocument.getId()), expectedDocument);
        documentTranslator = new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV2());
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, documentTranslator);
        expectedDocument = new Document();
        expectedDocument.setId(UUID.randomUUID().toString());
        expectedDocument.setTimestamp(System.currentTimeMillis());
        data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        expectedDocument.setData(data);
        this.hbaseDataStore.save(TEST_APP, expectedDocument);
        this.validateSave(documentTranslator.translate(TEST_APP, expectedDocument).getMetadata().getRawStorageId(), expectedDocument);
    }

    @Test
    public void testSaveSingleNullDocument() throws Exception {
        Document document = null;
        try {
            this.hbaseDataStore.save(TEST_APP, document);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveSingleNullId() throws Exception {
        Document document = this.createDummyDocument();
        document.setId(null);
        try {
            this.hbaseDataStore.save(TEST_APP, document);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveSingleNullData() throws Exception {
        Document document = new Document(UUID.randomUUID().toString(), System.currentTimeMillis(), null);
        try {
            this.hbaseDataStore.save(TEST_APP, document);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveSingleHBaseWriteException() throws Exception {
        Document document = new Document(UUID.randomUUID().toString(), System.currentTimeMillis(), this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST")));
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).put((Put)Matchers.any());
        try {
            this.hbaseDataStore.save(TEST_APP, document);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.STORE_CONNECTION_ERROR, (Object)ex.getCode());
        }
    }

    @Test(expected=StoreConnectionException.class)
    public void testSaveSingleHBaseCloseException() throws Exception {
        Document document = new Document(UUID.randomUUID().toString(), System.currentTimeMillis(), this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST")));
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).close();
        this.hbaseDataStore.save(TEST_APP, document);
    }

    @Test
    public void testSaveBulk() throws Exception {
        DocumentTranslator documentTranslator = new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV1());
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, documentTranslator);
        ArrayList documents = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        this.hbaseDataStore.saveAll(TEST_APP, (List)documents);
        for (Document document : documents) {
            this.validateSave(this.v1FormatKey(document.getId()), document);
        }
    }

    @Test
    public void testSaveBulkNullDocuments() throws Exception {
        Vector<Object> documents = new Vector<Object>();
        for (int i = 0; i < 10; ++i) {
            documents.add(null);
        }
        try {
            this.hbaseDataStore.saveAll(TEST_APP, documents);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveBulkNullIdList() throws Exception {
        List documents = null;
        try {
            this.hbaseDataStore.saveAll(TEST_APP, documents);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveBulkNullId() throws Exception {
        Vector<Document> documents = new Vector<Document>();
        for (int i = 0; i < 10; ++i) {
            documents.add(new Document(null, System.currentTimeMillis(), this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"))));
        }
        try {
            this.hbaseDataStore.saveAll(TEST_APP, documents);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveBulkNullData() throws Exception {
        Vector<Document> documents = new Vector<Document>();
        for (int i = 0; i < 10; ++i) {
            documents.add(new Document(UUID.randomUUID().toString(), System.currentTimeMillis(), null));
        }
        try {
            this.hbaseDataStore.saveAll(TEST_APP, documents);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveBulkHBaseWriteException() throws Exception {
        Vector<Document> documents = new Vector<Document>();
        documents.add(new Document(UUID.randomUUID().toString(), System.currentTimeMillis(), this.mapper.valueToTree(Collections.singletonMap("TEST", "TEST"))));
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).put(Matchers.anyListOf(Put.class));
        try {
            this.hbaseDataStore.saveAll(TEST_APP, documents);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.STORE_CONNECTION_ERROR, (Object)ex.getCode());
        }
    }

    @Test(expected=StoreConnectionException.class)
    public void testSaveBulkHBaseCloseException() throws Exception {
        Vector<Document> documents = new Vector<Document>();
        documents.add(new Document(UUID.randomUUID().toString(), System.currentTimeMillis(), this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "BULK_SAVE_TEST"))));
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).close();
        this.hbaseDataStore.saveAll(TEST_APP, documents);
    }

    public void validateSave(String id, Document expectedDocument) throws Exception {
        Get get = new Get(Bytes.toBytes((String)id));
        Result result = this.tableInterface.get(get);
        Assert.assertNotNull((String)"Get for Id should not be null", (Object)result);
        Document actualDocument = new Document(expectedDocument.getId(), expectedDocument.getTimestamp(), this.mapper.readTree(result.getValue(COLUMN_FAMILY, DATA_FIELD_NAME)));
        this.compare(expectedDocument, actualDocument);
    }

    private String v1FormatKey(String id) {
        return String.format("%s:%s", id, "test-table");
    }

    @Test
    public void testGetSingle() throws Exception {
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV1()));
        String id = UUID.randomUUID().toString();
        long timestamp = System.currentTimeMillis();
        JsonNode data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        Document expectedDocument = new Document(id, timestamp, data);
        this.tableInterface.put(new Put(Bytes.toBytes((String)this.v1FormatKey(id))).addColumn(COLUMN_FAMILY, Bytes.toBytes((String)"data"), this.mapper.writeValueAsBytes((Object)data)).addColumn(COLUMN_FAMILY, Bytes.toBytes((String)"timestamp"), Bytes.toBytes((long)timestamp)));
        Document actualDocument = this.hbaseDataStore.get(TEST_APP, id);
        this.compare(expectedDocument, actualDocument);
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV1()));
        id = UUID.randomUUID().toString();
        data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        String newId = this.v1FormatKey(id);
        expectedDocument = new Document(id, System.currentTimeMillis(), new DocumentMetadata(id, newId, timestamp), data);
        this.tableInterface.put(this.hbaseDataStore.getPutForDocument(expectedDocument));
        actualDocument = this.hbaseDataStore.get(TEST_APP, id);
        this.compare(expectedDocument, actualDocument);
        DocumentTranslator documentTranslator = new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV2());
        this.hbaseDataStore = new HBaseDataStore(this.hbaseTableConnection, this.mapper, documentTranslator);
        id = UUID.randomUUID().toString();
        data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        Document originalDocument = new Document(id, System.currentTimeMillis(), data);
        newId = documentTranslator.translate(TEST_APP, originalDocument).getId();
        expectedDocument = new Document(newId, originalDocument.getTimestamp(), new DocumentMetadata(id, newId, timestamp), data);
        this.tableInterface.put(this.hbaseDataStore.getPutForDocument(expectedDocument));
        actualDocument = this.hbaseDataStore.get(TEST_APP, newId);
        this.compare(originalDocument, actualDocument);
    }

    @Test
    public void testGetSingleMissingDocument() {
        try {
            this.hbaseDataStore.get(TEST_APP, UUID.randomUUID().toString());
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.DOCUMENT_NOT_FOUND, (Object)ex.getCode());
        }
    }

    @Test
    public void testGetSingleHBaseReadException() throws Exception {
        String id = UUID.randomUUID().toString();
        JsonNode data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        Document expectedDocument = new Document(id, System.currentTimeMillis(), new DocumentMetadata(id, this.v1FormatKey(id), System.currentTimeMillis()), data);
        this.tableInterface.put(this.hbaseDataStore.getPutForDocument(expectedDocument));
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).get((Get)Matchers.any());
        try {
            this.hbaseDataStore.get(TEST_APP, id);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.STORE_CONNECTION_ERROR, (Object)ex.getCode());
        }
    }

    @Test(expected=StoreConnectionException.class)
    public void testGetSingleHBaseCloseException() throws Exception {
        Document originalDocument = this.createDummyDocument();
        originalDocument.setMetadata(new DocumentMetadata(originalDocument.getId(), this.v1FormatKey(originalDocument.getId()), System.currentTimeMillis()));
        Document expectedDocument = new Document(this.v1FormatKey(originalDocument.getId()), originalDocument.getTimestamp(), originalDocument.getMetadata(), originalDocument.getData());
        this.tableInterface.put(this.hbaseDataStore.getPutForDocument(expectedDocument));
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).close();
        this.hbaseDataStore.get(TEST_APP, originalDocument.getId());
    }

    @Test
    public void testV1GetBulk() throws Exception {
        HashMap idValues = Maps.newHashMap();
        Vector<String> ids = new Vector<String>();
        Vector<Put> putList = new Vector<Put>();
        HashMap actualIdValues = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            String id = UUID.randomUUID().toString();
            long timestamp = System.currentTimeMillis();
            JsonNode data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "BULK_GET_TEST"));
            String rawId = this.v1FormatKey(id);
            ids.add(id);
            Document document = new Document(rawId, timestamp, new DocumentMetadata(id, rawId, timestamp), data);
            putList.add(this.hbaseDataStore.getPutForDocument(document));
            idValues.put(id, new Document(id, timestamp, data));
        }
        this.tableInterface.put(putList);
        List actualDocuments = this.hbaseDataStore.getAll(TEST_APP, ids);
        for (Document doc : actualDocuments) {
            actualIdValues.put(doc.getId(), doc);
        }
        Assert.assertNotNull((String)"List of returned Documents should not be null", (Object)actualDocuments);
        for (String id : ids) {
            Assert.assertTrue((String)"Requested Id should be present in response", (boolean)actualIdValues.containsKey(id));
            this.compare((Document)idValues.get(id), (Document)actualIdValues.get(id));
        }
    }

    @Test
    public void testV2GetBulk() throws Exception {
        DocumentTranslator translator = new DocumentTranslator(TestUtils.createTranslatorConfigWithRawKeyV2());
        HashMap idValues = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        ArrayList rawIds = Lists.newArrayList();
        ArrayList putList = Lists.newArrayList();
        HashMap actualIdValues = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Document document = this.createDummyDocument();
            ids.add(document.getId());
            idValues.put(document.getId(), document);
            Document translated = translator.translate(TEST_APP, document);
            putList.add(this.hbaseDataStore.getPutForDocument(translated));
            rawIds.add(translated.getId());
        }
        this.tableInterface.put((List)putList);
        List actualDocuments = this.hbaseDataStore.getAll(TEST_APP, (List)rawIds);
        for (Document doc : actualDocuments) {
            actualIdValues.put(doc.getId(), doc);
        }
        Assert.assertNotNull((String)"List of returned Documents should not be null", (Object)actualDocuments);
        for (String id : ids) {
            Assert.assertTrue((String)"Requested Id should be present in response", (boolean)actualIdValues.containsKey(id));
            this.compare((Document)idValues.get(id), (Document)actualIdValues.get(id));
        }
    }

    @Test
    public void testGetBulkNullIdList() throws Exception {
        try {
            this.hbaseDataStore.getAll(TEST_APP, null);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testGetBulkMissingDocument() throws Exception {
        Vector<String> ids = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            ids.add(UUID.randomUUID().toString());
        }
        try {
            this.hbaseDataStore.getAll(TEST_APP, ids);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.DOCUMENT_NOT_FOUND, (Object)ex.getCode());
        }
    }

    @Test
    public void testGetBulkHBaseReadException() throws Exception {
        ArrayList ids = new ArrayList();
        ArrayList<Put> putList = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            String id = UUID.randomUUID().toString();
            Document document = new Document(id, System.currentTimeMillis(), new DocumentMetadata(id, String.format("row:%d", i), System.currentTimeMillis()), this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "BULK_GET_TEST")));
            putList.add(this.hbaseDataStore.getPutForDocument(document));
        }
        this.tableInterface.put(putList);
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).get(Matchers.anyListOf(Get.class));
        try {
            this.hbaseDataStore.getAll(TEST_APP, ids);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test(expected=BadRequestException.class)
    public void testGetBulkHBaseCloseException() throws Exception {
        Vector ids = new Vector();
        Vector<Put> putList = new Vector<Put>();
        for (int i = 0; i < 10; ++i) {
            String id = UUID.randomUUID().toString();
            Document document = new Document(id, System.currentTimeMillis(), new DocumentMetadata(id, String.format("row:%d", i), System.currentTimeMillis()), this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "BULK_GET_TEST")));
            putList.add(this.hbaseDataStore.getPutForDocument(document));
        }
        this.tableInterface.put(putList);
        ((Table)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.tableInterface)).close();
        this.hbaseDataStore.getAll(TEST_APP, ids);
        ((Table)Mockito.verify((Object)this.tableInterface, (VerificationMode)Mockito.times((int)1))).close();
    }

    public void compare(Document expected, Document actual) throws Exception {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertNotNull((String)"Actual document Id should not be null", (Object)actual.getId());
        Assert.assertNotNull((String)"Actual document data should not be null", (Object)actual.getData());
        Assert.assertEquals((String)"Actual Doc Id should match expected Doc Id", (Object)expected.getId(), (Object)actual.getId());
        Assert.assertEquals((String)"Actual Doc Timestamp should match expected Doc Timestamp", (long)expected.getTimestamp(), (long)actual.getTimestamp());
        String expectedData = this.mapper.writeValueAsString((Object)expected.getData());
        String actualData = this.mapper.writeValueAsString((Object)actual.getData());
        Assert.assertEquals((String)"Actual data should match expected data", (Object)expectedData, (Object)actualData);
    }

    private Document createDummyDocument() {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        JsonNode data = this.mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        document.setData(data);
        return document;
    }
}

