/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.table.TableManager;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FoxtrotTableManager
implements TableManager {
    private final TableMetadataManager metadataManager;
    private final QueryStore queryStore;
    private final DataStore dataStore;

    @Inject
    public FoxtrotTableManager(TableMetadataManager metadataManager, QueryStore queryStore, DataStore dataStore) {
        this.metadataManager = metadataManager;
        this.queryStore = queryStore;
        this.dataStore = dataStore;
    }

    @Override
    public void save(Table table) {
        this.validateTableParams(table);
        if (this.metadataManager.exists(table.getName())) {
            throw FoxtrotExceptions.createTableExistsException(table.getName());
        }
        this.queryStore.initializeTable(table.getName());
        this.dataStore.initializeTable(table, false);
        this.metadataManager.save(table);
    }

    @Override
    public void save(Table table, boolean forceCreateTable) {
        this.validateTableParams(table);
        if (this.metadataManager.exists(table.getName())) {
            throw FoxtrotExceptions.createTableExistsException(table.getName());
        }
        this.dataStore.initializeTable(table, forceCreateTable);
        this.queryStore.initializeTable(table.getName());
        this.metadataManager.save(table);
    }

    @Override
    public Table get(String name) {
        Table table = this.metadataManager.get(name);
        if (table == null) {
            throw FoxtrotExceptions.createTableMissingException(name);
        }
        return table;
    }

    @Override
    public List<Table> getAll() {
        return this.metadataManager.get();
    }

    @Override
    public void update(Table table) {
        this.validateTableParams(table);
        if (!this.metadataManager.exists(table.getName())) {
            throw FoxtrotExceptions.createTableMissingException(table.getName());
        }
        this.metadataManager.save(table);
    }

    @Override
    public void delete(String tableName) {
    }

    private void validateTableParams(Table table) {
        if (table == null || table.getName() == null || table.getName().trim().isEmpty() || table.getTtl() <= 0) {
            throw FoxtrotExceptions.createBadRequestException(table != null ? table.getName() : null, "Invalid Table Params");
        }
    }
}

