/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.flipkart.foxtrot.core.querystore.impl.CustomESTransportClient;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConfig;
import io.dropwizard.lifecycle.Managed;
import java.net.InetAddress;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=5)
public class ElasticsearchConnection
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger((String)ElasticsearchConnection.class.getSimpleName());
    private final ElasticsearchConfig config;
    private Client client;

    @Inject
    public ElasticsearchConnection(ElasticsearchConfig config) {
        this.config = config;
    }

    public void start() throws Exception {
        logger.info("Starting ElasticSearch Client");
        Settings settings = Settings.builder().put("cluster.name", this.config.getCluster()).put("client.transport.ignore_cluster_name", true).build();
        CustomESTransportClient esClient = new CustomESTransportClient(settings);
        int port = this.config.getPort() == null ? 9300 : this.config.getPort();
        for (String host : this.config.getHosts()) {
            String[] tokenizedHosts;
            for (String tokenizedHost : tokenizedHosts = host.split(",")) {
                esClient.addTransportAddress(new TransportAddress(InetAddress.getByName(tokenizedHost), port));
                logger.info("Added ElasticSearch Node : {}", (Object)host);
            }
        }
        this.client = esClient;
        logger.info("Started ElasticSearch Client");
    }

    public void stop() throws Exception {
        logger.info("Stopping ElasticSearch client");
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticsearchConfig getConfig() {
        return this.config;
    }

    public void refresh(String index) {
        this.client.admin().indices().refresh((RefreshRequest)new RefreshRequest(new String[0]).indices(new String[]{index})).actionGet();
    }
}

