/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.google.common.collect.ImmutableList;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.Netty4Plugin;

public class CustomESTransportClient
extends TransportClient {
    private static void initializeNetty() {
        CustomESTransportClient.setSystemPropertyIfUnset("io.netty.noUnsafe", Boolean.toString(true));
        CustomESTransportClient.setSystemPropertyIfUnset("io.netty.noKeySetOptimization", Boolean.toString(true));
        CustomESTransportClient.setSystemPropertyIfUnset("io.netty.recycler.maxCapacityPerThread", Integer.toString(0));
    }

    @SuppressForbidden(reason="set system properties to configure Netty")
    private static void setSystemPropertyIfUnset(String key, String value) {
        String currentValue = System.getProperty(key);
        if (currentValue == null) {
            System.setProperty(key, value);
        }
    }

    public CustomESTransportClient(Settings settings) {
        super(settings, (Collection)ImmutableList.of(Netty4Plugin.class));
    }

    public void close() {
        super.close();
        if (!NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings) || ((String)NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings)).equals("netty4")) {
            try {
                GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        CustomESTransportClient.initializeNetty();
    }
}

