/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.stats.Stat;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.metrics.min.InternalMin;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.joda.time.DateTimeZone;

public class Utils {
    private static final double[] DEFAULT_PERCENTILES = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    private static final double DEFAULT_COMPRESSION = 100.0;
    private static final String COUNT = "count";
    private static final String AVG = "avg";
    private static final String SUM = "sum";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String SUM_OF_SQUARES = "sum_of_squares";
    private static final String VARIANCE = "variance";
    private static final String STD_DEVIATION = "std_deviation";

    private Utils() {
    }

    public static TermsAggregationBuilder buildTermsAggregation(List<ResultSort> fields, Set<AggregationBuilder> subAggregations) {
        TermsAggregationBuilder rootBuilder = null;
        TermsAggregationBuilder termsBuilder = null;
        for (ResultSort nestingField : fields) {
            String field = nestingField.getField();
            BucketOrder bucketOrder = BucketOrder.key((nestingField.getOrder() != ResultSort.Order.desc ? 1 : 0) != 0);
            if (null == termsBuilder) {
                termsBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)Utils.sanitizeFieldForAggregation(field)).field(Utils.storedFieldName(field))).order(bucketOrder);
            } else {
                TermsAggregationBuilder tempBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)Utils.sanitizeFieldForAggregation(field)).field(Utils.storedFieldName(field))).order(bucketOrder);
                termsBuilder.subAggregation((AggregationBuilder)tempBuilder);
                termsBuilder = tempBuilder;
            }
            termsBuilder.size(10000);
            if (null != rootBuilder) continue;
            rootBuilder = termsBuilder;
        }
        if (!CollectionUtils.isNullOrEmpty(subAggregations)) {
            assert (termsBuilder != null);
            for (AggregationBuilder aggregationBuilder : subAggregations) {
                termsBuilder.subAggregation(aggregationBuilder);
            }
        }
        return rootBuilder;
    }

    public static AbstractAggregationBuilder buildStatsAggregation(final String field, Set<Stat> stats) {
        boolean anyExtendedStat;
        final String metricKey = Utils.getExtendedStatsAggregationKey(field);
        boolean bl = anyExtendedStat = stats == null || stats.stream().anyMatch(Stat::isExtended);
        if (anyExtendedStat) {
            return AggregationBuilders.extendedStats((String)metricKey).field(Utils.storedFieldName(field));
        }
        if (stats.size() > 1) {
            return AggregationBuilders.stats((String)metricKey).field(Utils.storedFieldName(field));
        }
        Stat stat = stats.iterator().next();
        return (AbstractAggregationBuilder)stat.visit((Stat.StatVisitor)new Stat.StatVisitor<AbstractAggregationBuilder>(){

            public AbstractAggregationBuilder visitCount() {
                return AggregationBuilders.count((String)metricKey).field(Utils.storedFieldName(field));
            }

            public AbstractAggregationBuilder visitMin() {
                return AggregationBuilders.min((String)metricKey).field(field);
            }

            public AbstractAggregationBuilder visitMax() {
                return AggregationBuilders.max((String)metricKey).field(Utils.storedFieldName(field));
            }

            public AbstractAggregationBuilder visitAvg() {
                return AggregationBuilders.avg((String)metricKey).field(Utils.storedFieldName(field));
            }

            public AbstractAggregationBuilder visitSum() {
                return AggregationBuilders.sum((String)metricKey).field(Utils.storedFieldName(field));
            }

            public AbstractAggregationBuilder visitSumOfSquares() {
                throw FoxtrotExceptions.createServerException("InvalidCodePathForSumOfSquares", null);
            }

            public AbstractAggregationBuilder visitVariance() {
                throw FoxtrotExceptions.createServerException("InvalidCodePathForVariance", null);
            }

            public AbstractAggregationBuilder visitStdDeviation() {
                throw FoxtrotExceptions.createServerException("InvalidCodePathForStdDeviation", null);
            }
        });
    }

    public static AbstractAggregationBuilder buildPercentileAggregation(String field, Collection<Double> inputPercentiles) {
        return Utils.buildPercentileAggregation(field, inputPercentiles, 100.0);
    }

    public static AbstractAggregationBuilder buildPercentileAggregation(String field, Collection<Double> inputPercentiles, double compression) {
        double[] percentiles;
        double[] dArray = percentiles = inputPercentiles != null ? inputPercentiles.stream().mapToDouble(x -> x).toArray() : DEFAULT_PERCENTILES;
        if (compression == 0.0) {
            compression = 100.0;
        }
        String metricKey = Utils.getPercentileAggregationKey(field);
        return ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)metricKey).percentiles(percentiles).field(Utils.storedFieldName(field))).compression(compression);
    }

    public static DateHistogramAggregationBuilder buildDateHistogramAggregation(String field, DateHistogramInterval interval) {
        String metricKey = Utils.getDateHistogramKey(field);
        return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)metricKey).minDocCount(0L).field(Utils.storedFieldName(field))).timeZone(DateTimeZone.getDefault())).dateHistogramInterval(interval);
    }

    public static CardinalityAggregationBuilder buildCardinalityAggregation(String field) {
        return (CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)Utils.sanitizeFieldForAggregation(field)).precisionThreshold(500L).field(Utils.storedFieldName(field));
    }

    public static String sanitizeFieldForAggregation(String field) {
        return field.replaceAll("[^a-zA-Z0-9\\-_]", "_");
    }

    public static String storedFieldName(String field) {
        if ("_timestamp".equalsIgnoreCase(field)) {
            return ElasticsearchUtils.DOCUMENT_META_TIMESTAMP_FIELD_NAME;
        }
        return field;
    }

    public static DateHistogramInterval getHistogramInterval(Period period) {
        DateHistogramInterval interval;
        switch (period) {
            case seconds: {
                interval = DateHistogramInterval.SECOND;
                break;
            }
            case minutes: {
                interval = DateHistogramInterval.MINUTE;
                break;
            }
            case hours: {
                interval = DateHistogramInterval.HOUR;
                break;
            }
            case days: {
                interval = DateHistogramInterval.DAY;
                break;
            }
            default: {
                interval = DateHistogramInterval.HOUR;
            }
        }
        return interval;
    }

    public static String getExtendedStatsAggregationKey(String field) {
        return Utils.sanitizeFieldForAggregation(field) + "_extended_stats";
    }

    public static String getPercentileAggregationKey(String field) {
        return Utils.sanitizeFieldForAggregation(field) + "_percentile";
    }

    public static String getDateHistogramKey(String field) {
        return Utils.sanitizeFieldForAggregation(field) + "_date_histogram";
    }

    public static IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public static Map<String, Number> createStatsResponse(InternalExtendedStats extendedStats) {
        HashMap stats = Maps.newHashMap();
        stats.put(AVG, extendedStats.getAvg());
        stats.put(SUM, extendedStats.getSum());
        stats.put(COUNT, extendedStats.getCount());
        stats.put(MIN, extendedStats.getMin());
        stats.put(MAX, extendedStats.getMax());
        stats.put(SUM_OF_SQUARES, extendedStats.getSumOfSquares());
        stats.put(VARIANCE, extendedStats.getVariance());
        stats.put(STD_DEVIATION, extendedStats.getStdDeviation());
        return stats;
    }

    public static Map<String, Number> createStatsResponse(InternalStats internalStats) {
        HashMap stats = Maps.newHashMap();
        stats.put(AVG, internalStats.getAvg());
        stats.put(SUM, internalStats.getSum());
        stats.put(COUNT, internalStats.getCount());
        stats.put(MIN, internalStats.getMin());
        stats.put(MAX, internalStats.getMax());
        return stats;
    }

    public static Map<String, Number> createStatResponse(InternalMax statAggregation) {
        return ImmutableMap.of((Object)MAX, (Object)statAggregation.getValue());
    }

    public static Map<String, Number> createStatResponse(InternalMin statAggregation) {
        return ImmutableMap.of((Object)MIN, (Object)statAggregation.getValue());
    }

    public static Map<String, Number> createStatResponse(InternalAvg statAggregation) {
        return ImmutableMap.of((Object)AVG, (Object)statAggregation.getValue());
    }

    public static Map<String, Number> createStatResponse(InternalSum statAggregation) {
        return ImmutableMap.of((Object)SUM, (Object)statAggregation.getValue());
    }

    public static Map<String, Number> createStatResponse(InternalValueCount statAggregation) {
        return ImmutableMap.of((Object)COUNT, (Object)statAggregation.getValue());
    }

    public static Map<Number, Number> createPercentilesResponse(Percentiles internalPercentiles) {
        HashMap percentiles = Maps.newHashMap();
        for (Percentile percentile : internalPercentiles) {
            percentiles.put(percentile.getPercent(), percentile.getValue());
        }
        return percentiles;
    }

    public static double ensurePositive(long number) {
        return (double)number <= 0.0 ? 0.0 : (double)number;
    }

    public static double ensureOne(long number) {
        return number <= 0L ? 1.0 : (double)number;
    }

    public static Map<String, Number> toStats(Aggregation statAggregation) {
        if (statAggregation instanceof InternalExtendedStats) {
            return Utils.createStatsResponse((InternalExtendedStats)statAggregation);
        }
        if (statAggregation instanceof InternalStats) {
            return Utils.createStatsResponse((InternalStats)statAggregation);
        }
        if (statAggregation instanceof InternalMax) {
            return Utils.createStatResponse((InternalMax)statAggregation);
        }
        if (statAggregation instanceof InternalMin) {
            return Utils.createStatResponse((InternalMin)statAggregation);
        }
        if (statAggregation instanceof InternalAvg) {
            return Utils.createStatResponse((InternalAvg)statAggregation);
        }
        if (statAggregation instanceof InternalSum) {
            return Utils.createStatResponse((InternalSum)statAggregation);
        }
        if (statAggregation instanceof InternalValueCount) {
            return Utils.createStatResponse((InternalValueCount)statAggregation);
        }
        return new HashMap<String, Number>();
    }
}

