/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.query.general.InFilter;
import com.flipkart.foxtrot.common.trend.TrendRequest;
import com.flipkart.foxtrot.common.trend.TrendResponse;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.joda.time.DateTime;

@AnalyticsProvider(opcode="trend", request=TrendRequest.class, response=TrendResponse.class, cacheable=true)
public class TrendAction
extends Action<TrendRequest> {
    public TrendAction(TrendRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
    }

    @Override
    public void preprocess() {
        ((TrendRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((TrendRequest)this.getParameter()).getTable()));
        if (null != ((TrendRequest)this.getParameter()).getValues() && !((TrendRequest)this.getParameter()).getValues().isEmpty()) {
            List values = ((TrendRequest)this.getParameter()).getValues();
            InFilter filter = new InFilter(((TrendRequest)this.getParameter()).getField(), values);
            ((TrendRequest)this.getParameter()).getFilters().add(filter);
        }
    }

    @Override
    public String getMetricKey() {
        return ((TrendRequest)this.getParameter()).getTable();
    }

    @Override
    public String getRequestCacheKey() {
        TrendRequest query = (TrendRequest)this.getParameter();
        long filterHashKey = 0L;
        if (query.getFilters() != null) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (query.getValues() != null) {
            for (String value : query.getValues()) {
                filterHashKey += (long)(31 * value.hashCode());
            }
        }
        if (null != query.getUniqueCountOn()) {
            filterHashKey += (long)(31 * query.getUniqueCountOn().hashCode());
        }
        filterHashKey += (long)(31 * query.getPeriod().name().hashCode());
        filterHashKey += (long)(31 * query.getTimestamp().hashCode());
        return String.format("%s-%s-%s-%d", query.getTable(), query.getField(), query.getPeriod(), filterHashKey += (long)(31 * (query.getField() != null ? query.getField().hashCode() : "FIELD".hashCode())));
    }

    @Override
    public void validateImpl(TrendRequest parameter) {
        ArrayList validationErrors = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("field name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTimestamp())) {
            validationErrors.add("timestamp field cannot be null or empty");
        }
        if (parameter.getPeriod() == null) {
            validationErrors.add(String.format("specify time period (%s)", StringUtils.join((Object[])Period.values())));
        }
        if (parameter.getUniqueCountOn() != null && parameter.getUniqueCountOn().isEmpty()) {
            validationErrors.add("unique field cannot be empty (can be null)");
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(TrendRequest parameter) {
        SearchRequestBuilder searchRequestBuilder = this.getRequestBuilder(parameter);
        try {
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout());
            return this.getResponse((ActionResponse)searchResponse, parameter);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    public SearchRequestBuilder getRequestBuilder(TrendRequest parameter) {
        SearchRequestBuilder searchRequestBuilder;
        try {
            AbstractAggregationBuilder aggregationBuilder = this.buildAggregation(parameter);
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(10000).addAggregation((AggregationBuilder)aggregationBuilder);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        return searchRequestBuilder;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse response, TrendRequest parameter) {
        Aggregations aggregations = ((SearchResponse)response).getAggregations();
        if (aggregations != null) {
            return this.buildResponse(parameter, aggregations);
        }
        return new TrendResponse(Collections.emptyMap());
    }

    @Override
    protected Filter getDefaultTimeSpan() {
        LastFilter lastFilter = new LastFilter();
        lastFilter.setField("_timestamp");
        lastFilter.setDuration(Duration.days((long)1L));
        return lastFilter;
    }

    private AbstractAggregationBuilder buildAggregation(TrendRequest request) {
        DateHistogramInterval interval = Utils.getHistogramInterval(request.getPeriod());
        String field = request.getField();
        DateHistogramAggregationBuilder histogramBuilder = Utils.buildDateHistogramAggregation(request.getTimestamp(), interval);
        if (!CollectionUtils.isNullOrEmpty((String)((TrendRequest)this.getParameter()).getUniqueCountOn())) {
            histogramBuilder.subAggregation((AggregationBuilder)Utils.buildCardinalityAggregation(((TrendRequest)this.getParameter()).getUniqueCountOn()));
        }
        return Utils.buildTermsAggregation(Lists.newArrayList((Object[])new ResultSort[]{new ResultSort(field, ResultSort.Order.asc)}), Sets.newHashSet((Object[])new AggregationBuilder[]{histogramBuilder}));
    }

    private TrendResponse buildResponse(TrendRequest request, Aggregations aggregations) {
        String field = request.getField();
        TreeMap<String, ArrayList> trendCounts = new TreeMap<String, ArrayList>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        for (Terms.Bucket bucket : terms.getBuckets()) {
            String key = String.valueOf(bucket.getKey());
            ArrayList counts = Lists.newArrayList();
            Aggregations subAggregations = bucket.getAggregations();
            Histogram histogram = (Histogram)subAggregations.get(Utils.getDateHistogramKey(request.getTimestamp()));
            for (Histogram.Bucket histogramBucket : histogram.getBuckets()) {
                if (!CollectionUtils.isNullOrEmpty((String)((TrendRequest)this.getParameter()).getUniqueCountOn())) {
                    String uniqueCountKey = Utils.sanitizeFieldForAggregation(((TrendRequest)this.getParameter()).getUniqueCountOn());
                    Cardinality cardinality = (Cardinality)histogramBucket.getAggregations().get(uniqueCountKey);
                    counts.add(new TrendResponse.Count((Number)((DateTime)histogramBucket.getKey()).getMillis(), cardinality.getValue()));
                    continue;
                }
                counts.add(new TrendResponse.Count((Number)((DateTime)histogramBucket.getKey()).getMillis(), histogramBucket.getDocCount()));
            }
            trendCounts.put(key, counts);
        }
        return new TrendResponse(trendCounts);
    }
}

