/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.FieldMetadata;
import com.flipkart.foxtrot.common.FieldType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.MappingMetaData;

public class ElasticsearchMappingParser {
    private static final String PROPERTIES = "properties";
    private ObjectMapper mapper;

    public ElasticsearchMappingParser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Set<FieldMetadata> getFieldMappings(MappingMetaData metaData) {
        JsonNode jsonNode = this.mapper.valueToTree((Object)metaData.getSourceAsMap());
        return this.generateFieldMappings(null, jsonNode.get(PROPERTIES));
    }

    private Set<FieldMetadata> generateFieldMappings(String parentField, JsonNode jsonNode) {
        HashSet<FieldMetadata> fieldTypeMappings = new HashSet<FieldMetadata>();
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            String currentField;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((String)entry.getKey()).startsWith("__FOXTROT_METADATA__")) continue;
            String string = currentField = parentField == null ? (String)entry.getKey() : String.format("%s.%s", parentField, entry.getKey());
            if (((JsonNode)entry.getValue()).has(PROPERTIES)) {
                fieldTypeMappings.addAll(this.generateFieldMappings(currentField, ((JsonNode)entry.getValue()).get(PROPERTIES)));
                continue;
            }
            FieldType fieldType = this.getFieldType(((JsonNode)entry.getValue()).get("type"));
            fieldTypeMappings.add(FieldMetadata.builder().field(currentField).type(fieldType).build());
        }
        return fieldTypeMappings;
    }

    private FieldType getFieldType(JsonNode jsonNode) {
        String type = jsonNode.asText();
        FieldType fieldType = FieldType.valueOf((String)type.toUpperCase());
        if (fieldType == FieldType.TEXT || fieldType == FieldType.KEYWORD) {
            return FieldType.STRING;
        }
        return fieldType;
    }
}

