/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.exception;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CardinalityOverflowException
extends FoxtrotException {
    private static final long serialVersionUID = -8591567152701424689L;
    private final String requestStr;
    private final String field;
    private final ActionRequest actionRequest;
    private final double probability;

    public CardinalityOverflowException(ActionRequest actionRequest, String requestStr, String field, double probability) {
        super(ErrorCode.CARDINALITY_OVERFLOW, "Query blocked due to high cardinality. Consider using shorter time period");
        this.requestStr = requestStr;
        this.field = field;
        this.actionRequest = actionRequest;
        this.probability = probability;
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)"field", (Object)this.field).put((Object)"probability", (Object)this.probability).put((Object)"request", (Object)this.actionRequest).put((Object)"requestStr", (Object)this.requestStr).build();
    }

    public String getRequestStr() {
        return this.requestStr;
    }

    public String getField() {
        return this.field;
    }

    public ActionRequest getActionRequest() {
        return this.actionRequest;
    }

    public double getProbability() {
        return this.probability;
    }
}

