/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.exception;

import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BadRequestException
extends FoxtrotException {
    private final String table;
    private final List<String> messages;

    protected BadRequestException(String table, List<String> messages) {
        super(ErrorCode.INVALID_REQUEST);
        this.table = table;
        this.messages = messages;
    }

    public BadRequestException(String table, Exception e) {
        super(ErrorCode.INVALID_REQUEST, (Throwable)e);
        this.table = table;
        this.messages = Collections.singletonList(e.getMessage());
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap map = Maps.newHashMap();
        map.put("table", this.table);
        map.put("messages", this.messages);
        return map;
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getMessages() {
        return this.messages;
    }
}

