/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.datastore.impl.hbase;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.DocumentMetadata;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseTableConnection;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.foxtrot.flipkart.translator.DocumentTranslator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HBaseDataStore
implements DataStore {
    private static final Logger logger = LoggerFactory.getLogger((String)HBaseDataStore.class.getSimpleName());
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"d");
    private static final byte[] DOCUMENT_FIELD_NAME = Bytes.toBytes((String)"data");
    private static final byte[] DOCUMENT_META_FIELD_NAME = Bytes.toBytes((String)"metadata");
    private static final byte[] TIMESTAMP_FIELD_NAME = Bytes.toBytes((String)"timestamp");
    private static final byte[] DATE_FIELD_NAME = Bytes.toBytes((String)"date");
    private final HbaseTableConnection tableWrapper;
    private final ObjectMapper mapper;
    private final DocumentTranslator translator;

    @Inject
    public HBaseDataStore(HbaseTableConnection tableWrapper, ObjectMapper mapper, DocumentTranslator translator) {
        this.tableWrapper = tableWrapper;
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    @Timed
    public void initializeTable(com.flipkart.foxtrot.common.Table table, boolean forceTableCreate) {
        try {
            boolean isTableAvailable = this.tableWrapper.isTableAvailable(table);
            if (isTableAvailable) {
                return;
            }
            if (!forceTableCreate) {
                throw FoxtrotExceptions.createTableInitializationException(table, String.format("Create HBase Table - %s", this.tableWrapper.getHBaseTableName(table)));
            }
            this.tableWrapper.createTable(table);
        }
        catch (IOException e) {
            throw FoxtrotExceptions.createConnectionException(table, e);
        }
    }

    @Override
    @Timed
    public Document save(com.flipkart.foxtrot.common.Table table, Document document) {
        if (document == null || document.getData() == null || document.getId() == null) {
            throw FoxtrotExceptions.createBadRequestException(table.getName(), "Invalid Input Document");
        }
        Document translatedDocument = null;
        try (Table hTable = this.tableWrapper.getTable(table);){
            translatedDocument = this.translator.translate(table, document);
            hTable.put(this.getPutForDocument(translatedDocument));
        }
        catch (JsonProcessingException e) {
            throw FoxtrotExceptions.createBadRequestException(table, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw FoxtrotExceptions.createConnectionException(table, e);
        }
        return translatedDocument;
    }

    @Override
    @Timed
    public List<Document> saveAll(com.flipkart.foxtrot.common.Table table, List<Document> documents) {
        if (documents == null || documents.isEmpty()) {
            throw FoxtrotExceptions.createBadRequestException(table.getName(), "null/empty document list not allowed");
        }
        ArrayList<Put> puts = new ArrayList<Put>();
        ImmutableList.Builder translatedDocuments = ImmutableList.builder();
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            for (int i = 0; i < documents.size(); ++i) {
                Document document = documents.get(i);
                if (!this.isValidDocument(document, errorMessages, i)) continue;
                Document translatedDocument = this.translator.translate(table, document);
                puts.add(this.getPutForDocument(translatedDocument));
                translatedDocuments.add((Object)translatedDocument);
            }
        }
        catch (JsonProcessingException e) {
            throw FoxtrotExceptions.createBadRequestException(table, (Exception)((Object)e));
        }
        if (!errorMessages.isEmpty()) {
            throw FoxtrotExceptions.createBadRequestException(table.getName(), errorMessages);
        }
        try (Table hTable = this.tableWrapper.getTable(table);){
            hTable.put(puts);
        }
        catch (IOException e) {
            throw FoxtrotExceptions.createConnectionException(table, e);
        }
        return translatedDocuments.build();
    }

    private boolean isValidDocument(Document document, List<String> errorMessages, int index) {
        if (document == null) {
            errorMessages.add("null document at index - " + index);
            return false;
        }
        if (document.getId() == null || document.getId().trim().isEmpty()) {
            errorMessages.add("null/empty document id at index - " + index);
            return false;
        }
        if (document.getData() == null) {
            errorMessages.add("null document data at index - " + index);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Timed
    public Document get(com.flipkart.foxtrot.common.Table table, String id) {
        try (Table hTable = this.tableWrapper.getTable(table);){
            Get get = new Get(Bytes.toBytes((String)this.translator.rawStorageIdFromDocumentId(table, id))).addColumn(COLUMN_FAMILY, DOCUMENT_FIELD_NAME).addColumn(COLUMN_FAMILY, DOCUMENT_META_FIELD_NAME).addColumn(COLUMN_FAMILY, TIMESTAMP_FIELD_NAME).setMaxVersions(1);
            Result getResult = hTable.get(get);
            if (!getResult.isEmpty()) {
                byte[] data = getResult.getValue(COLUMN_FAMILY, DOCUMENT_FIELD_NAME);
                byte[] metadata = getResult.getValue(COLUMN_FAMILY, DOCUMENT_META_FIELD_NAME);
                byte[] timestamp = getResult.getValue(COLUMN_FAMILY, TIMESTAMP_FIELD_NAME);
                long time = Bytes.toLong((byte[])timestamp);
                DocumentMetadata documentMetadata = null != metadata ? (DocumentMetadata)this.mapper.readValue(metadata, DocumentMetadata.class) : null;
                Document document = this.translator.translateBack(new Document(id, time, documentMetadata, this.mapper.readTree(data)));
                return document;
            }
            logger.error("ID missing in HBase - {}", (Object)id);
            throw FoxtrotExceptions.createMissingDocumentException(table, id);
        }
        catch (IOException e) {
            throw FoxtrotExceptions.createConnectionException(table, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Timed
    public List<Document> getAll(com.flipkart.foxtrot.common.Table table, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw FoxtrotExceptions.createBadRequestException(table.getName(), "Empty ID List");
        }
        try (Table hTable = this.tableWrapper.getTable(table);){
            ArrayList<Get> gets = new ArrayList<Get>(ids.size());
            for (String id : ids) {
                Get get = new Get(Bytes.toBytes((String)this.translator.rawStorageIdFromDocumentId(table, id))).addColumn(COLUMN_FAMILY, DOCUMENT_FIELD_NAME).addColumn(COLUMN_FAMILY, DOCUMENT_META_FIELD_NAME).addColumn(COLUMN_FAMILY, TIMESTAMP_FIELD_NAME).setMaxVersions(1);
                gets.add(get);
            }
            Result[] getResults = hTable.get(gets);
            ArrayList<String> missingIds = new ArrayList<String>();
            ArrayList<Document> results = new ArrayList<Document>(ids.size());
            for (int index = 0; index < getResults.length; ++index) {
                Result getResult = getResults[index];
                if (!getResult.isEmpty()) {
                    byte[] data = getResult.getValue(COLUMN_FAMILY, DOCUMENT_FIELD_NAME);
                    byte[] metadata = getResult.getValue(COLUMN_FAMILY, DOCUMENT_META_FIELD_NAME);
                    byte[] timestamp = getResult.getValue(COLUMN_FAMILY, TIMESTAMP_FIELD_NAME);
                    long time = Bytes.toLong((byte[])timestamp);
                    DocumentMetadata documentMetadata = null != metadata ? (DocumentMetadata)this.mapper.readValue(metadata, DocumentMetadata.class) : null;
                    String docId = null == metadata ? Bytes.toString((byte[])getResult.getRow()).split(":")[0] : documentMetadata.getRawStorageId();
                    results.add(this.translator.translateBack(new Document(docId, time, documentMetadata, this.mapper.readTree(data))));
                    continue;
                }
                missingIds.add(ids.get(index));
            }
            if (!missingIds.isEmpty()) {
                String allIds = String.join((CharSequence)",", ids);
                logger.error("ID's missing in HBase - {}", (Object)allIds);
                throw FoxtrotExceptions.createMissingDocumentsException(table, ids);
            }
            ArrayList<Document> arrayList = results;
            return arrayList;
        }
        catch (JsonProcessingException e) {
            throw FoxtrotExceptions.createBadRequestException(table, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw FoxtrotExceptions.createConnectionException(table, e);
        }
    }

    @VisibleForTesting
    public Put getPutForDocument(Document document) throws JsonProcessingException {
        return new Put(Bytes.toBytes((String)document.getMetadata().getRawStorageId())).addColumn(COLUMN_FAMILY, DOCUMENT_META_FIELD_NAME, this.mapper.writeValueAsBytes((Object)document.getMetadata())).addColumn(COLUMN_FAMILY, DOCUMENT_FIELD_NAME, this.mapper.writeValueAsBytes((Object)document.getData())).addColumn(COLUMN_FAMILY, TIMESTAMP_FIELD_NAME, Bytes.toBytes((long)document.getTimestamp())).addColumn(COLUMN_FAMILY, DATE_FIELD_NAME, this.mapper.writeValueAsBytes((Object)document.getDate()));
    }
}

