/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cardinality;

import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.util.Set;
import java.util.stream.Collectors;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardinalityCalculationRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CardinalityCalculationRunnable.class.getSimpleName());
    private final TableMetadataManager tableMetadataManager;

    public CardinalityCalculationRunnable(TableMetadataManager tableMetadataManager) {
        this.tableMetadataManager = tableMetadataManager;
    }

    @Override
    @SchedulerLock(name="cardinalityCalculation")
    public void run() {
        try {
            Set tables = this.tableMetadataManager.get().stream().map(Table::getName).collect(Collectors.toSet());
            for (String table : tables) {
                if (this.tableMetadataManager.cardinalityCacheContains(table)) continue;
                this.tableMetadataManager.getFieldMappings(table, true, true);
                LOGGER.info("Cardinality calculated for table: {}", (Object)table);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while calculating cardinality {}", (Throwable)e);
        }
    }
}

