/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.alerts;

import com.flipkart.foxtrot.core.alerts.EmailBuilder;
import com.flipkart.foxtrot.core.email.Email;
import com.flipkart.foxtrot.core.email.EmailClient;
import com.flipkart.foxtrot.core.email.RichEmailBuilder;
import com.flipkart.foxtrot.core.internalevents.InternalEventBusConsumer;
import com.flipkart.foxtrot.core.internalevents.InternalSystemEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertingSystemEventConsumer
implements InternalEventBusConsumer {
    private static final Logger log = LoggerFactory.getLogger(AlertingSystemEventConsumer.class);
    private final EmailClient emailClient;
    private final RichEmailBuilder richEmailBuilder;

    @Inject
    public AlertingSystemEventConsumer(EmailClient emailClient, RichEmailBuilder richEmailBuilder) {
        this.emailClient = emailClient;
        this.richEmailBuilder = richEmailBuilder;
    }

    @Override
    public void process(InternalSystemEvent event) {
        Email email = event.accept(new EmailBuilder(this.richEmailBuilder));
        if (null == email) {
            return;
        }
        this.emailClient.sendEmail(email);
    }
}

