/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchTestUtils {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchTestUtils.class);

    public static ElasticsearchConnection getConnection() throws Exception {
        ElasticsearchConfig config = new ElasticsearchConfig();
        config.setCluster("elasticsearch");
        config.setHosts(Collections.singletonList("localhost"));
        config.setTableNamePrefix("foxtrot");
        ElasticsearchConnection elasticsearchConnection = new ElasticsearchConnection(config);
        elasticsearchConnection.start();
        return elasticsearchConnection;
    }

    public static void cleanupIndices(ElasticsearchConnection elasticsearchConnection) {
        try {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest("_all");
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)elasticsearchConnection.getClient().admin().indices().delete(deleteIndexRequest).get();
            log.info("Delete index response: {}", (Object)deleteIndexResponse);
        }
        catch (Exception e) {
            log.error("Index Cleanup failed", (Throwable)e);
        }
    }
}

