/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.Stat;
import com.flipkart.foxtrot.common.stats.StatsRequest;
import com.flipkart.foxtrot.common.stats.StatsResponse;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StatsActionTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getStatsDocuments(StatsActionTest.getMapper());
        StatsActionTest.getQueryStore().save("test-table", documents);
        StatsActionTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test
    public void testStatsActionWithoutNesting() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)150L, (long)((Number)statsResponse.getResult().getStats().get("sum")).intValue());
        Assert.assertEquals((long)5L, (long)((Number)statsResponse.getResult().getStats().get("count")).intValue());
        Assert.assertNull((Object)statsResponse.getBuckets());
    }

    @Test
    public void testStatsActionNoExtendedStat() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setStats(EnumSet.allOf(Stat.class).stream().filter(x -> !x.isExtended()).collect(Collectors.toSet()));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)5L, (long)statsResponse.getResult().getStats().size());
    }

    @Test
    public void testStatsActionOnlyCountStat() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.COUNT));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)1L, (long)statsResponse.getResult().getStats().size());
        Assert.assertTrue((boolean)statsResponse.getResult().getStats().containsKey("count"));
    }

    @Test
    public void testStatsActionOnlyMaxStat() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.MAX));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)1L, (long)statsResponse.getResult().getStats().size());
        Assert.assertTrue((boolean)statsResponse.getResult().getStats().containsKey("max"));
    }

    @Test
    public void testStatsActionOnlyMinStat() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.MIN));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)1L, (long)statsResponse.getResult().getStats().size());
        Assert.assertTrue((boolean)statsResponse.getResult().getStats().containsKey("min"));
    }

    @Test
    public void testStatsActionOnlyAvgStat() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.AVG));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)1L, (long)statsResponse.getResult().getStats().size());
        Assert.assertTrue((boolean)statsResponse.getResult().getStats().containsKey("avg"));
    }

    @Test
    public void testStatsActionOnlySumStat() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.SUM));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertTrue((boolean)statsResponse.getResult().getStats().containsKey("sum"));
    }

    @Test
    public void testStatsActionOnlyOnePercentile() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setPercentiles(Collections.singletonList(5.0));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsResponse statsResponse = (StatsResponse)StatsActionTest.getQueryExecutor().execute((ActionRequest)request);
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)1L, (long)statsResponse.getResult().getPercentiles().size());
        Assert.assertTrue((boolean)statsResponse.getResult().getPercentiles().containsKey(5.0));
    }

    @Test
    public void testStatsActionWithNesting() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os"}));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)3L, (long)statsResponse.getBuckets().size());
        for (BucketResponse bucketResponse : statsResponse.getBuckets()) {
            Assert.assertNotNull((Object)bucketResponse.getResult());
        }
    }

    @Test
    public void testStatsActionWithMultiLevelNesting() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(StatsActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)3L, (long)statsResponse.getBuckets().size());
        for (BucketResponse bucketResponse : statsResponse.getBuckets()) {
            Assert.assertNull((Object)bucketResponse.getResult());
            Assert.assertNotNull((Object)bucketResponse.getBuckets());
        }
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsActionNullTable() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable(null);
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsActionTest.getQueryExecutor().execute((ActionRequest)request);
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsActionNullField() throws FoxtrotException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField(null);
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsActionTest.getQueryExecutor().execute((ActionRequest)request);
    }
}

