/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.query.MultiTimeQueryRequest;
import com.flipkart.foxtrot.common.query.MultiTimeQueryResponse;
import com.flipkart.foxtrot.common.query.Query;
import com.flipkart.foxtrot.common.query.QueryResponse;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiTimeQueryActionTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getQueryDocuments(MultiTimeQueryActionTest.getMapper());
        MultiTimeQueryActionTest.getQueryStore().save("test-table", documents);
        MultiTimeQueryActionTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test
    public void testMultiTimeQuery() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.asc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        BetweenFilter betweenFilter = new BetweenFilter("_timestamp", (Number)1397658117000L, (Number)1397658118005L, false);
        query.setFilters(Arrays.asList(betweenFilter));
        Duration duration = Duration.days((long)1L);
        MultiTimeQueryRequest multiTimeQueryRequest = new MultiTimeQueryRequest(1, duration, (ActionRequest)query);
        ActionResponse actionResponse = MultiTimeQueryActionTest.getQueryExecutor().execute((ActionRequest)multiTimeQueryRequest);
        MultiTimeQueryResponse multiTimeQueryResponse = null;
        if (actionResponse instanceof MultiTimeQueryResponse) {
            multiTimeQueryResponse = (MultiTimeQueryResponse)actionResponse;
        }
        Assert.assertNotNull(multiTimeQueryResponse);
        QueryResponse queryResponse = (QueryResponse)multiTimeQueryResponse.getResponses().get("1397658117000");
        Assert.assertEquals((long)9L, (long)queryResponse.getTotalHits());
    }

    @Test
    public void testQueryNoFilterAscending() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.asc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        BetweenFilter betweenFilter = new BetweenFilter("_timestamp", (Number)1397658117000L, (Number)1397658118005L, false);
        query.setFilters(Arrays.asList(betweenFilter));
        Duration duration = Duration.days((long)1L);
        MultiTimeQueryRequest multiTimeQueryRequest = new MultiTimeQueryRequest(1, duration, (ActionRequest)query);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, MultiTimeQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, MultiTimeQueryActionTest.getMapper()));
        MultiTimeQueryResponse multiTimeQueryResponse = (MultiTimeQueryResponse)MultiTimeQueryResponse.class.cast(MultiTimeQueryActionTest.getQueryExecutor().execute((ActionRequest)multiTimeQueryRequest));
        for (String key : multiTimeQueryResponse.getResponses().keySet()) {
            this.compare(documents, ((QueryResponse)multiTimeQueryResponse.getResponses().get(key)).getDocuments());
        }
    }

    public void compare(List<Document> expectedDocuments, List<Document> actualDocuments) {
        Assert.assertEquals((long)expectedDocuments.size(), (long)actualDocuments.size());
        for (int i = 0; i < expectedDocuments.size(); ++i) {
            Document expected = expectedDocuments.get(i);
            Document actual = actualDocuments.get(i);
            Assert.assertNotNull((Object)expected);
            Assert.assertNotNull((Object)actual);
            Assert.assertNotNull((String)"Actual document Id should not be null", (Object)actual.getId());
            Assert.assertNotNull((String)"Actual document data should not be null", (Object)actual.getData());
            Assert.assertEquals((String)"Actual Doc Id should match expected Doc Id", (Object)expected.getId(), (Object)actual.getId());
            Assert.assertEquals((String)"Actual Doc Timestamp should match expected Doc Timestamp", (long)expected.getTimestamp(), (long)actual.getTimestamp());
            Map expectedMap = (Map)MultiTimeQueryActionTest.getMapper().convertValue((Object)expected.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            Map actualMap = (Map)MultiTimeQueryActionTest.getMapper().convertValue((Object)actual.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            Assert.assertEquals((String)"Actual data should match expected data", (Object)expectedMap, (Object)actualMap);
        }
    }
}

