/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.CardinalityOverflowException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchQueryStore;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupActionEstimationTest
extends ActionTest {
    private static final Logger log = LoggerFactory.getLogger(GroupActionEstimationTest.class);

    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getGroupDocumentsForEstimation(GroupActionEstimationTest.getMapper());
        GroupActionEstimationTest.getQueryStore().save("test-table", documents);
        GroupActionEstimationTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
        GroupActionEstimationTest.getTableMetadataManager().getFieldMappings("test-table", true, true, 1397658117000L);
        ((ElasticsearchQueryStore)GroupActionEstimationTest.getQueryStore()).getCardinalityConfig().setMaxCardinality(15000L);
        GroupActionEstimationTest.getTableMetadataManager().updateEstimationData("test-table", 1397658117000L);
    }

    @Test
    public void testEstimationNoFilter() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("os"));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertTrue((boolean)response.getResult().containsKey("android"));
        Assert.assertTrue((boolean)response.getResult().containsKey("ios"));
    }

    @Test(expected=CardinalityOverflowException.class)
    public void testEstimationNoFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest);
    }

    @Test
    public void testEstimationTemporalFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)BetweenFilter.builder().field("_timestamp").temporal(true).from((Number)1397658117000L).to((Number)1397658237000L).build()));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        Assert.assertFalse((boolean)response.getResult().isEmpty());
    }

    @Test
    public void testEstimationCardinalFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)EqualsFilter.builder().field("os").value((Object)"ios").build()));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        Assert.assertFalse((boolean)response.getResult().isEmpty());
    }

    @Test(expected=CardinalityOverflowException.class)
    public void testEstimationGTFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)GreaterThanFilter.builder().field("value").value((Number)10).build()));
        GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest);
    }

    @Test
    public void testEstimationLTFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)LessThanFilter.builder().field("value").value((Number)30).build()));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        Assert.assertFalse((boolean)response.getResult().isEmpty());
    }

    public void testEstimationLTFilterHighCardinalityBlocked() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)LessThanFilter.builder().field("value").value((Number)80).build()));
        log.debug(GroupActionEstimationTest.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupActionEstimationTest.getQueryExecutor().execute((ActionRequest)groupRequest);
    }
}

