/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.cache.impl.DistributedCacheFactory;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.config.TextNodeRemoverConfiguration;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.email.EmailConfig;
import com.flipkart.foxtrot.core.querystore.QueryExecutor;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.handlers.ResponseCacheUpdater;
import com.flipkart.foxtrot.core.querystore.impl.CacheConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchQueryStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.querystore.mutator.IndexerEventMutator;
import com.flipkart.foxtrot.core.querystore.mutator.LargeTextNodeRemover;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.DistributedTableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.ElasticsearchTestUtils;
import com.google.common.collect.Lists;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.elasticsearch.client.Client;
import org.joda.time.DateTimeZone;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public abstract class ActionTest {
    private static HazelcastInstance hazelcastInstance;
    private static ElasticsearchConnection elasticsearchConnection;
    private static ObjectMapper mapper;
    private static QueryStore queryStore;
    private static QueryExecutor queryExecutor;
    private static DistributedTableMetadataManager tableMetadataManager;
    private static CacheManager cacheManager;

    @BeforeClass
    public static void setupClass() throws Exception {
        hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance(new Config());
        elasticsearchConnection = ElasticsearchTestUtils.getConnection();
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)"Asia/Kolkata"));
        mapper = new ObjectMapper();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        EmailConfig emailConfig = new EmailConfig();
        emailConfig.setHost("127.0.0.1");
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)hazelcastInstance.getConfig());
        CardinalityConfig cardinalityConfig = new CardinalityConfig("true", String.valueOf(50));
        TestUtils.ensureIndex(elasticsearchConnection, "table-meta");
        TestUtils.ensureIndex(elasticsearchConnection, "table_cardinality_cache");
        ElasticsearchUtils.initializeMappings((Client)elasticsearchConnection.getClient());
        tableMetadataManager = new DistributedTableMetadataManager(hazelcastConnection, elasticsearchConnection, mapper, cardinalityConfig);
        tableMetadataManager.start();
        tableMetadataManager.save(Table.builder().name("test-table").ttl(30).build());
        ArrayList mutators = Lists.newArrayList((Object[])new IndexerEventMutator[]{new LargeTextNodeRemover(mapper, TextNodeRemoverConfiguration.builder().build())});
        DataStore dataStore = TestUtils.getDataStore();
        queryStore = new ElasticsearchQueryStore((TableMetadataManager)tableMetadataManager, elasticsearchConnection, dataStore, (List)mutators, mapper, cardinalityConfig);
        cacheManager = new CacheManager((CacheFactory)new DistributedCacheFactory(hazelcastConnection, mapper, new CacheConfig()));
        AnalyticsLoader analyticsLoader = new AnalyticsLoader((TableMetadataManager)tableMetadataManager, dataStore, queryStore, elasticsearchConnection, cacheManager, mapper);
        analyticsLoader.start();
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        queryExecutor = new QueryExecutor(analyticsLoader, executorService, Collections.singletonList(new ResponseCacheUpdater(cacheManager)));
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        hazelcastInstance.shutdown();
        ElasticsearchTestUtils.cleanupIndices(elasticsearchConnection);
        elasticsearchConnection.stop();
    }

    public static ElasticsearchConnection getElasticsearchConnection() {
        return elasticsearchConnection;
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static QueryStore getQueryStore() {
        return queryStore;
    }

    public static QueryExecutor getQueryExecutor() {
        return queryExecutor;
    }

    public static DistributedTableMetadataManager getTableMetadataManager() {
        return tableMetadataManager;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    static {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.WARN);
    }
}

