/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.cache.impl.DistributedCacheFactory;
import com.flipkart.foxtrot.core.common.RequestWithNoAction;
import com.flipkart.foxtrot.core.common.noncacheable.NonCacheableAction;
import com.flipkart.foxtrot.core.common.noncacheable.NonCacheableActionRequest;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.QueryExecutor;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.impl.CacheConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.ElasticsearchTestUtils;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.elasticsearch.client.Client;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class QueryExecutorTest {
    private static HazelcastInstance hazelcastInstance;
    private static ElasticsearchConnection elasticsearchConnection;
    private QueryExecutor queryExecutor;
    private ObjectMapper mapper = new ObjectMapper();
    private AnalyticsLoader analyticsLoader;

    @BeforeClass
    public static void setupClass() throws Exception {
        hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance(new Config());
        elasticsearchConnection = ElasticsearchTestUtils.getConnection();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        hazelcastInstance.shutdown();
        elasticsearchConnection.stop();
    }

    @Before
    public void setUp() throws Exception {
        DataStore dataStore = TestUtils.getDataStore();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)new Config());
        CacheManager cacheManager = new CacheManager((CacheFactory)new DistributedCacheFactory(hazelcastConnection, this.mapper, new CacheConfig()));
        ElasticsearchUtils.initializeMappings((Client)elasticsearchConnection.getClient());
        TableMetadataManager tableMetadataManager = (TableMetadataManager)Mockito.mock(TableMetadataManager.class);
        Mockito.when((Object)tableMetadataManager.exists(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)tableMetadataManager.get(Mockito.anyString())).thenReturn((Object)TestUtils.TEST_TABLE);
        QueryStore queryStore = (QueryStore)Mockito.mock(QueryStore.class);
        this.analyticsLoader = (AnalyticsLoader)Mockito.spy((Object)new AnalyticsLoader(tableMetadataManager, dataStore, queryStore, elasticsearchConnection, cacheManager, this.mapper));
        TestUtils.registerActions(this.analyticsLoader, this.mapper);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        this.queryExecutor = new QueryExecutor(this.analyticsLoader, executorService, Collections.emptyList());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testResolve() throws Exception {
        Assert.assertEquals(NonCacheableAction.class, this.queryExecutor.resolve((ActionRequest)new NonCacheableActionRequest()).getClass());
    }

    @Test
    public void testResolveNonExistentAction() throws Exception {
        try {
            this.queryExecutor.resolve((ActionRequest)new RequestWithNoAction());
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.UNRESOLVABLE_OPERATION, (Object)e.getCode());
        }
    }
}

