/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.alerts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.core.alerts.EmailBuilder;
import com.flipkart.foxtrot.core.email.Email;
import com.flipkart.foxtrot.core.email.RichEmailBuilder;
import com.flipkart.foxtrot.core.email.messageformatting.EmailBodyBuilder;
import com.flipkart.foxtrot.core.email.messageformatting.EmailSubjectBuilder;
import com.flipkart.foxtrot.core.email.messageformatting.impl.StrSubstitutorEmailBodyBuilder;
import com.flipkart.foxtrot.core.email.messageformatting.impl.StrSubstitutorEmailSubjectBuilder;
import com.flipkart.foxtrot.core.exception.CardinalityOverflowException;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.internalevents.events.QueryProcessingError;
import com.google.common.collect.Lists;
import io.dropwizard.jackson.Jackson;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class EmailBuilderTest {
    @Test
    public void testCardinalityEmailBuild() throws JsonProcessingException {
        EmailBuilder emailBuilder = new EmailBuilder(new RichEmailBuilder((EmailSubjectBuilder)new StrSubstitutorEmailSubjectBuilder(), (EmailBodyBuilder)new StrSubstitutorEmailBodyBuilder()));
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "deviceId"}));
        QueryProcessingError error = new QueryProcessingError((ActionRequest)groupRequest, (FoxtrotException)new CardinalityOverflowException((ActionRequest)groupRequest, Jackson.newObjectMapper().writeValueAsString((Object)groupRequest), "deviceId", 0.75));
        Email email = emailBuilder.visit(error);
        Assert.assertEquals((Object)"Blocked query as it might have screwed up the cluster", (Object)email.getSubject());
        Assert.assertEquals((Object)"Blocked Query: {\"opcode\":\"group\",\"filters\":[],\"table\":\"test-table\",\"uniqueCountOn\":null,\"nesting\":[\"os\",\"deviceId\"]}\nSuspect field: deviceId\nProbability of screwing up the cluster: 0.75", (Object)email.getContent());
    }
}

