/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.util;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;

public class MetricUtil {
    private static MetricRegistry metrics = new MetricRegistry();
    private static final MetricUtil metricsHelper = new MetricUtil();
    private static final String packagePrefix = "com.flipkart.foxtrot.core";
    private static final String actionMetricPrefix = "action";

    public static void setup(MetricRegistry metrics) {
        MetricUtil.metrics = metrics;
    }

    public static MetricUtil getInstance() {
        return metricsHelper;
    }

    private MetricUtil() {
        JmxReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.MINUTES).build().start();
    }

    public void registerActionCacheHit(String opcode, String metricKey) {
        this.registerActionCacheOperation(opcode, metricKey, "success");
    }

    public void registerActionCacheMiss(String opcode, String metricKey) {
        this.registerActionCacheOperation(opcode, metricKey, "failure");
    }

    private void registerActionCacheOperation(String opcode, String metricKey, String status) {
        metrics.meter(String.format("%s.%s.cache.%s", packagePrefix, actionMetricPrefix, status)).mark();
        metrics.meter(String.format("%s.%s.%s.cache.%s", packagePrefix, actionMetricPrefix, opcode, status)).mark();
        metrics.meter(String.format("%s.%s.%s.%s.cache.%s", packagePrefix, actionMetricPrefix, opcode, metricKey, status)).mark();
    }

    public void registerActionSuccess(String opcode, String metricKey, long duration) {
        this.registerActionOperation(opcode, metricKey, "success", duration);
    }

    public void registerActionFailure(String opcode, String metricKey, long duration) {
        this.registerActionOperation(opcode, metricKey, "failure", duration);
    }

    private void registerActionOperation(String opcode, String metricKey, String status, long duration) {
        metrics.timer(String.format("%s.%s.%s", packagePrefix, actionMetricPrefix, opcode)).update(duration, TimeUnit.MILLISECONDS);
        metrics.timer(String.format("%s.%s.%s.%s", packagePrefix, actionMetricPrefix, opcode, metricKey)).update(duration, TimeUnit.MILLISECONDS);
        metrics.timer(String.format("%s.%s.%s.%s.%s", packagePrefix, actionMetricPrefix, opcode, metricKey, status)).update(duration, TimeUnit.MILLISECONDS);
    }
}

