/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConfig;
import io.dropwizard.lifecycle.Managed;
import java.net.InetAddress;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchConnection
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger((String)ElasticsearchConnection.class.getSimpleName());
    private final ElasticsearchConfig config;
    private Client client;

    public ElasticsearchConnection(ElasticsearchConfig config) {
        this.config = config;
    }

    public void start() throws Exception {
        logger.info("Starting Elasticsearch Client");
        Settings settings = Settings.settingsBuilder().put("cluster.name", this.config.getCluster()).build();
        TransportClient esClient = TransportClient.builder().settings(settings).build();
        for (String host : this.config.getHosts()) {
            String[] tokenizedHosts;
            for (String tokenizedHost : tokenizedHosts = host.split(",")) {
                esClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(tokenizedHost), 9300));
                logger.info(String.format("Added Elasticsearch Node : %s", host));
            }
        }
        this.client = esClient;
        logger.info("Started Elasticsearch Client");
    }

    public void stop() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticsearchConfig getConfig() {
        return this.config;
    }
}

