/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.histogram.HistogramRequest;
import com.flipkart.foxtrot.common.histogram.HistogramResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.joda.time.DateTime;

@AnalyticsProvider(opcode="histogram", request=HistogramRequest.class, response=HistogramResponse.class, cacheable=true)
public class HistogramAction
extends Action<HistogramRequest> {
    public HistogramAction(HistogramRequest parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        super(parameter, tableMetadataManager, dataStore, queryStore, connection, cacheToken, cacheManager, objectMapper);
    }

    @Override
    protected void preprocess() {
        ((HistogramRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((HistogramRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((HistogramRequest)this.getParameter()).getTable();
    }

    @Override
    protected String getRequestCacheKey() {
        long filterHashKey = 0L;
        HistogramRequest query = (HistogramRequest)this.getParameter();
        if (null != query.getFilters()) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (null != query.getUniqueCountOn()) {
            filterHashKey += (long)(31 * query.getUniqueCountOn().hashCode());
        }
        return String.format("%s-%s-%s-%d", query.getTable(), query.getPeriod().name(), query.getField(), filterHashKey);
    }

    @Override
    public void validateImpl(HistogramRequest parameter) throws MalformedQueryException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("timestamp field cannot be null or empty");
        }
        if (parameter.getPeriod() == null) {
            validationErrors.add("time period cannot be null");
        }
        if (parameter.getUniqueCountOn() != null && parameter.getUniqueCountOn().isEmpty()) {
            validationErrors.add("distinct field cannot be empty (can be null)");
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public ActionResponse execute(HistogramRequest parameter) throws FoxtrotException {
        SearchRequestBuilder searchRequestBuilder;
        AbstractAggregationBuilder aggregationBuilder = this.buildAggregation();
        try {
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(0).addAggregation(aggregationBuilder);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        try {
            SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout());
            Aggregations aggregations = response.getAggregations();
            return this.buildResponse(aggregations);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    private HistogramResponse buildResponse(Aggregations aggregations) {
        if (aggregations == null) {
            return new HistogramResponse(Collections.emptyList());
        }
        String dateHistogramKey = Utils.getDateHistogramKey(((HistogramRequest)this.getParameter()).getField());
        Histogram dateHistogram = (Histogram)aggregations.get(dateHistogramKey);
        List buckets = dateHistogram.getBuckets();
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>(buckets.size());
        for (Histogram.Bucket bucket : buckets) {
            if (!CollectionUtils.isNullOrEmpty((String)((HistogramRequest)this.getParameter()).getUniqueCountOn())) {
                String key = Utils.sanitizeFieldForAggregation(((HistogramRequest)this.getParameter()).getUniqueCountOn());
                Cardinality cardinality = (Cardinality)bucket.getAggregations().get(key);
                counts.add(new HistogramResponse.Count((Number)((DateTime)bucket.getKey()).getMillis(), cardinality.getValue()));
                continue;
            }
            counts.add(new HistogramResponse.Count((Number)((DateTime)bucket.getKey()).getMillis(), bucket.getDocCount()));
        }
        return new HistogramResponse(counts);
    }

    private AbstractAggregationBuilder buildAggregation() {
        DateHistogramInterval interval = Utils.getHistogramInterval(((HistogramRequest)this.getParameter()).getPeriod());
        DateHistogramBuilder histogramBuilder = Utils.buildDateHistogramAggregation(((HistogramRequest)this.getParameter()).getField(), interval);
        if (!CollectionUtils.isNullOrEmpty((String)((HistogramRequest)this.getParameter()).getUniqueCountOn())) {
            histogramBuilder.subAggregation((AbstractAggregationBuilder)Utils.buildCardinalityAggregation(((HistogramRequest)this.getParameter()).getUniqueCountOn()));
        }
        return histogramBuilder;
    }

    @Override
    protected Filter getDefaultTimeSpan() {
        LastFilter lastFilter = new LastFilter();
        lastFilter.setField("_timestamp");
        lastFilter.setDuration(Duration.days((long)1L));
        return lastFilter;
    }
}

