/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.Query;
import com.flipkart.foxtrot.common.query.QueryResponse;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.util.ArrayList;
import java.util.Collections;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyticsProvider(opcode="query", request=Query.class, response=QueryResponse.class, cacheable=false)
public class FilterAction
extends Action<Query> {
    private static final Logger logger = LoggerFactory.getLogger(FilterAction.class);

    public FilterAction(Query parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        super(parameter, tableMetadataManager, dataStore, queryStore, connection, cacheToken, cacheManager, objectMapper);
    }

    @Override
    protected void preprocess() {
        ((Query)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((Query)this.getParameter()).getTable()));
        if (null == ((Query)this.getParameter()).getSort()) {
            ResultSort resultSort = new ResultSort();
            resultSort.setField("_timestamp");
            resultSort.setOrder(ResultSort.Order.desc);
            ((Query)this.getParameter()).setSort(resultSort);
        }
    }

    @Override
    public String getMetricKey() {
        return ((Query)this.getParameter()).getTable();
    }

    @Override
    protected String getRequestCacheKey() {
        long filterHashKey = 0L;
        Query query = (Query)this.getParameter();
        if (null != query.getFilters()) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        return String.format("%s-%d-%d-%d", query.getTable(), query.getFrom(), query.getLimit(), filterHashKey += (long)(31 * (query.getSort() != null ? query.getSort().hashCode() : "SORT".hashCode())));
    }

    @Override
    public void validateImpl(Query parameter) throws MalformedQueryException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (parameter.getSort() == null) {
            validationErrors.add("sort order needs to be specified");
        }
        if (parameter.getFrom() < 0) {
            validationErrors.add("from must be non-negative integer");
        }
        if (parameter.getLimit() <= 0) {
            validationErrors.add("limit must be positive integer");
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    public QueryResponse execute(Query parameter) throws FoxtrotException {
        SearchRequestBuilder search;
        try {
            search = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSearchType(SearchType.QUERY_THEN_FETCH).setFrom(parameter.getFrom()).addSort(parameter.getSort().getField(), ResultSort.Order.desc == parameter.getSort().getOrder() ? SortOrder.DESC : SortOrder.ASC).setSize(parameter.getLimit());
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        try {
            logger.info("Search: {}", (Object)search);
            SearchResponse response = (SearchResponse)search.execute().actionGet(this.getGetQueryTimeout());
            ArrayList<String> ids = new ArrayList<String>();
            SearchHits searchHits = response.getHits();
            for (SearchHit searchHit : searchHits) {
                ids.add(searchHit.getId());
            }
            if (ids.isEmpty()) {
                return new QueryResponse(Collections.emptyList(), 0L);
            }
            return new QueryResponse(this.getQueryStore().getAll(parameter.getTable(), ids, true), searchHits.totalHits());
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }
}

