/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.count.CountRequest;
import com.flipkart.foxtrot.common.count.CountResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.general.ExistsFilter;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.util.ArrayList;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;

@AnalyticsProvider(opcode="count", request=CountRequest.class, response=CountResponse.class, cacheable=false)
public class CountAction
extends Action<CountRequest> {
    public CountAction(CountRequest parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        super(parameter, tableMetadataManager, dataStore, queryStore, connection, cacheToken, cacheManager, objectMapper);
    }

    @Override
    protected void preprocess() {
        ((CountRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((CountRequest)this.getParameter()).getTable()));
        if (((CountRequest)this.getParameter()).getField() != null) {
            ((CountRequest)this.getParameter()).getFilters().add(new ExistsFilter(((CountRequest)this.getParameter()).getField()));
        }
    }

    @Override
    public String getMetricKey() {
        return ((CountRequest)this.getParameter()).getTable();
    }

    @Override
    protected String getRequestCacheKey() {
        long filterHashKey = 0L;
        CountRequest request = (CountRequest)this.getParameter();
        if (null != request.getFilters()) {
            for (Filter filter : request.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        filterHashKey += (long)(31 * (request.isDistinct() ? "TRUE".hashCode() : "FALSE".hashCode()));
        return String.format("count-%s-%d", request.getTable(), filterHashKey += (long)(31 * (request.getField() != null ? request.getField().hashCode() : "COLUMN".hashCode())));
    }

    @Override
    public void validateImpl(CountRequest parameter) throws MalformedQueryException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (parameter.isDistinct() && CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("field name cannot be null or empty");
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public ActionResponse execute(CountRequest parameter) throws FoxtrotException {
        SearchRequestBuilder requestBuilder;
        if (parameter.isDistinct()) {
            SearchRequestBuilder query;
            try {
                query = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setIndicesOptions(Utils.indicesOptions()).setSize(0).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).addAggregation((AbstractAggregationBuilder)Utils.buildCardinalityAggregation(parameter.getField()));
            }
            catch (Exception e) {
                throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
            }
            try {
                SearchResponse response = (SearchResponse)query.execute().actionGet(this.getGetQueryTimeout());
                Aggregations aggregations = response.getAggregations();
                Cardinality cardinality = (Cardinality)aggregations.get(Utils.sanitizeFieldForAggregation(parameter.getField()));
                if (cardinality == null) {
                    return new CountResponse(0L);
                }
                return new CountResponse(cardinality.getValue());
            }
            catch (ElasticsearchException e) {
                throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
            }
        }
        try {
            requestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setIndicesOptions(Utils.indicesOptions()).setSize(0).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters()));
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        try {
            return new CountResponse(((SearchResponse)requestBuilder.execute().actionGet(this.getGetQueryTimeout())).getHits().getTotalHits());
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }
}

