/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore;

import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.DocumentMetadata;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseConfig;
import com.flipkart.foxtrot.core.datastore.impl.hbase.IdentityKeyDistributor;
import com.flipkart.foxtrot.core.querystore.actions.Constants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.sematext.hbase.ds.AbstractRowKeyDistributor;
import com.sematext.hbase.ds.RowKeyDistributorByHashPrefix;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTranslator {
    private static final Logger logger = LoggerFactory.getLogger(DocumentTranslator.class);
    private String rawKeyVersion;
    private final AbstractRowKeyDistributor keyDistributor;

    public DocumentTranslator(HbaseConfig hbaseConfig) {
        if (CollectionUtils.isNullOrEmpty((String)hbaseConfig.getRawKeyVersion()) || hbaseConfig.getRawKeyVersion().equalsIgnoreCase("1.0")) {
            this.keyDistributor = new IdentityKeyDistributor();
            this.rawKeyVersion = "1.0";
        } else if (hbaseConfig.getRawKeyVersion().equalsIgnoreCase("2.0")) {
            this.keyDistributor = new RowKeyDistributorByHashPrefix((RowKeyDistributorByHashPrefix.Hasher)new RowKeyDistributorByHashPrefix.OneByteSimpleHash(32));
            this.rawKeyVersion = "2.0";
        } else {
            throw new IllegalArgumentException(String.format("rawKeyVersion not supported version=[%s]", hbaseConfig.getRawKeyVersion()));
        }
    }

    public List<Document> translate(Table table, List<Document> inDocuments) {
        ImmutableList.Builder docListBuilder = ImmutableList.builder();
        for (Document document : inDocuments) {
            docListBuilder.add((Object)this.translate(table, document));
        }
        return docListBuilder.build();
    }

    public Document translate(Table table, Document inDocument) {
        Document document = new Document();
        DocumentMetadata metadata = this.metadata(table, inDocument);
        switch (this.rawKeyVersion) {
            case "1.0": {
                document.setId(inDocument.getId());
                break;
            }
            case "2.0": {
                document.setId(metadata.getRawStorageId());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("rawKeyVersion not supported version=[%s]", this.rawKeyVersion));
            }
        }
        document.setTimestamp(inDocument.getTimestamp());
        document.setMetadata(metadata);
        document.setData(inDocument.getData());
        return document;
    }

    public Document translateBack(Document inDocument) {
        Document document = new Document();
        document.setId(inDocument.getMetadata() != null ? inDocument.getMetadata().getId() : inDocument.getId());
        document.setTimestamp(inDocument.getTimestamp());
        document.setData(inDocument.getData());
        return document;
    }

    public DocumentMetadata metadata(Table table, Document inDocument) {
        String rowKey = this.generateScalableKey(this.rawStorageIdFromDocument(table, inDocument));
        DocumentMetadata metadata = new DocumentMetadata();
        metadata.setRawStorageId(rowKey);
        metadata.setId(inDocument.getId());
        return metadata;
    }

    public String rawStorageIdFromDocument(Table table, Document document) {
        switch (this.rawKeyVersion) {
            case "1.0": {
                return document.getId() + ":" + table.getName();
            }
            case "2.0": {
                return String.format("%s:%020d:%s:%s", table.getName(), document.getTimestamp(), document.getId(), Constants.rawKeyVersionToSuffixMap.get(this.rawKeyVersion));
            }
        }
        throw new IllegalArgumentException(String.format("rawKeyVersion not supported version=[%s]", this.rawKeyVersion));
    }

    @VisibleForTesting
    public String generateScalableKey(String id) {
        return new String(this.keyDistributor.getDistributedKey(Bytes.toBytes((String)id)));
    }

    public String rawStorageIdFromDocumentId(Table table, String id) {
        if (id.endsWith(Constants.rawKeyVersionToSuffixMap.get("2.0"))) {
            return id;
        }
        return String.format("%s:%s", id, table.getName());
    }
}

