/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.common;

import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.FilterVisitor;
import com.flipkart.foxtrot.common.query.FilterVisitorAdapter;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.query.datetime.TimeWindow;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import java.util.List;
import org.joda.time.Interval;

public class PeriodSelector
extends FilterVisitorAdapter<Void> {
    private final TimeWindow timeWindow = new TimeWindow();
    private final List<Filter> filters;

    public PeriodSelector(List<Filter> filters) {
        super(null);
        this.filters = filters;
        this.timeWindow.setStartTime(Long.MAX_VALUE);
        this.timeWindow.setEndTime(Long.MIN_VALUE);
    }

    public Interval analyze() throws Exception {
        return this.analyze(System.currentTimeMillis());
    }

    public Interval analyze(long currentTime) throws Exception {
        for (Filter filter : this.filters) {
            if (!filter.isFilterTemporal()) continue;
            filter.accept((FilterVisitor)this);
        }
        for (Filter filter : this.filters) {
            if (!"time".equals(filter.getField())) continue;
            filter.accept((FilterVisitor)this);
        }
        this.timeWindow.setStartTime(this.timeWindow.getStartTime() == Long.MAX_VALUE ? 0L : this.timeWindow.getStartTime());
        this.timeWindow.setEndTime(this.timeWindow.getEndTime() == Long.MIN_VALUE ? currentTime : this.timeWindow.getEndTime());
        return new Interval(this.timeWindow.getStartTime(), this.timeWindow.getEndTime());
    }

    public Void visit(BetweenFilter betweenFilter) throws Exception {
        this.timeWindow.setStartTime(Math.min((Long)betweenFilter.getFrom(), this.timeWindow.getStartTime()));
        this.timeWindow.setEndTime(Math.max((Long)betweenFilter.getTo(), this.timeWindow.getEndTime()));
        return null;
    }

    public Void visit(GreaterThanFilter greaterThanFilter) throws Exception {
        this.timeWindow.setStartTime(Math.min((Long)greaterThanFilter.getValue() + 1L, this.timeWindow.getStartTime()));
        return null;
    }

    public Void visit(GreaterEqualFilter greaterEqualFilter) throws Exception {
        this.timeWindow.setStartTime(Math.min((Long)greaterEqualFilter.getValue(), this.timeWindow.getStartTime()));
        return null;
    }

    public Void visit(LessThanFilter lessThanFilter) throws Exception {
        this.timeWindow.setEndTime(Math.max((Long)lessThanFilter.getValue() - 1L, this.timeWindow.getEndTime()));
        return null;
    }

    public Void visit(LessEqualFilter lessEqualFilter) throws Exception {
        this.timeWindow.setEndTime(Math.max((Long)lessEqualFilter.getValue(), this.timeWindow.getEndTime()));
        return null;
    }

    public Void visit(LastFilter lastFilter) throws Exception {
        TimeWindow window = lastFilter.getWindow();
        this.timeWindow.setStartTime(window.getStartTime());
        this.timeWindow.setEndTime(window.getEndTime());
        return null;
    }
}

