/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cardinality;

import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.jobs.BaseJobManager;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardinalityCalculationManager
extends BaseJobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CardinalityCalculationManager.class.getSimpleName());
    private final TableMetadataManager tableMetadataManager;
    private final CardinalityConfig cardinalityConfig;

    public CardinalityCalculationManager(TableMetadataManager tableMetadataManager, CardinalityConfig cardinalityConfig, HazelcastConnection hazelcastConnection, ScheduledExecutorService scheduledExecutorService) {
        super(cardinalityConfig, scheduledExecutorService, hazelcastConnection);
        this.tableMetadataManager = tableMetadataManager;
        this.cardinalityConfig = cardinalityConfig;
    }

    @Override
    protected void runImpl(LockingTaskExecutor executor, Instant lockAtMostUntil) {
        executor.executeWithLock(() -> {
            try {
                Set tables = this.tableMetadataManager.get().stream().map(Table::getName).collect(Collectors.toSet());
                for (String table : tables) {
                    this.tableMetadataManager.getFieldMappings(table, true, true);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while calculating cardinality " + e);
            }
        }, new LockConfiguration(this.cardinalityConfig.getJobName(), lockAtMostUntil));
    }
}

