/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.MockElasticsearchServer;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.cache.impl.DistributedCacheFactory;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.querystore.QueryExecutor;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.impl.CacheConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchQueryStore;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.DistributedTableMetadataManager;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class ActionTest {
    private ObjectMapper mapper;
    private QueryStore queryStore;
    private QueryExecutor queryExecutor;
    private HazelcastInstance hazelcastInstance;
    private MockElasticsearchServer elasticsearchServer;
    private ElasticsearchConnection elasticsearchConnection;
    private DistributedTableMetadataManager tableMetadataManager;

    @Before
    public void setUp() throws Exception {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)"Asia/Kolkata"));
        this.mapper = new ObjectMapper();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        Config config = new Config();
        this.hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance(config);
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)this.hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)config);
        this.elasticsearchServer = new MockElasticsearchServer(UUID.randomUUID().toString());
        this.elasticsearchConnection = TestUtils.initESConnection(this.elasticsearchServer);
        CardinalityConfig cardinalityConfig = new CardinalityConfig("true", String.valueOf(50));
        this.tableMetadataManager = new DistributedTableMetadataManager(hazelcastConnection, this.elasticsearchConnection, this.mapper, cardinalityConfig);
        this.tableMetadataManager.start();
        this.tableMetadataManager.save(Table.builder().name("test-table").ttl(30).build());
        DataStore dataStore = TestUtils.getDataStore();
        this.queryStore = new ElasticsearchQueryStore((TableMetadataManager)this.tableMetadataManager, this.elasticsearchConnection, dataStore, this.mapper, cardinalityConfig);
        CacheManager cacheManager = new CacheManager((CacheFactory)new DistributedCacheFactory(hazelcastConnection, this.mapper, new CacheConfig()));
        AnalyticsLoader analyticsLoader = new AnalyticsLoader((TableMetadataManager)this.tableMetadataManager, dataStore, this.queryStore, this.elasticsearchConnection, cacheManager, this.mapper);
        analyticsLoader.start();
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        this.queryExecutor = new QueryExecutor(analyticsLoader, executorService);
    }

    @After
    public void tearDown() throws Exception {
        this.getElasticsearchServer().shutdown();
        this.getHazelcastInstance().shutdown();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public QueryStore getQueryStore() {
        return this.queryStore;
    }

    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public MockElasticsearchServer getElasticsearchServer() {
        return this.elasticsearchServer;
    }

    public ElasticsearchConnection getElasticsearchConnection() {
        return this.elasticsearchConnection;
    }

    public DistributedTableMetadataManager getTableMetadataManager() {
        return this.tableMetadataManager;
    }

    static {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.WARN);
    }
}

