/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.MockElasticsearchServer;
import com.flipkart.foxtrot.core.MockHTable;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HBaseDataStore;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseConfig;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseTableConnection;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.DocumentTranslator;
import com.flipkart.foxtrot.core.querystore.actions.spi.ActionMetadata;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.joda.time.DateTime;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)TestUtils.class.getSimpleName());
    public static final String TEST_TABLE_NAME = "test-table";
    public static final Table TEST_TABLE = Table.builder().name("test-table").ttl(7).build();

    public static DataStore getDataStore() throws FoxtrotException {
        MockHTable tableInterface = MockHTable.create();
        HbaseTableConnection tableConnection = (HbaseTableConnection)Mockito.mock(HbaseTableConnection.class);
        ((HbaseTableConnection)Mockito.doReturn((Object)tableInterface).when((Object)tableConnection)).getTable((Table)Matchers.any());
        ((HbaseTableConnection)Mockito.doReturn((Object)new HbaseConfig()).when((Object)tableConnection)).getHbaseConfig();
        HBaseDataStore hBaseDataStore = new HBaseDataStore(tableConnection, new ObjectMapper(), new DocumentTranslator(TestUtils.createHBaseConfigWithRawKeyV2()));
        hBaseDataStore = (HBaseDataStore)Mockito.spy((Object)hBaseDataStore);
        return hBaseDataStore;
    }

    public static Document getDocument(String id, long timestamp, Object[] args, ObjectMapper mapper) {
        HashMap data = Maps.newHashMap();
        for (int i = 0; i < args.length; i += 2) {
            data.put((String)args[i], args[i + 1]);
        }
        return new Document(id, timestamp, mapper.valueToTree((Object)data));
    }

    public static void registerActions(AnalyticsLoader analyticsLoader, ObjectMapper mapper) throws Exception {
        Reflections reflections = new Reflections("com.flipkart.foxtrot", new Scanner[]{new SubTypesScanner()});
        Set actions = reflections.getSubTypesOf(Action.class);
        if (actions.isEmpty()) {
            throw new Exception("No analytics actions found!!");
        }
        Vector<NamedType> types = new Vector<NamedType>();
        for (Class action : actions) {
            AnalyticsProvider analyticsProvider = action.getAnnotation(AnalyticsProvider.class);
            if (null == analyticsProvider.request() || null == analyticsProvider.opcode() || analyticsProvider.opcode().isEmpty() || null == analyticsProvider.response()) {
                throw new Exception("Invalid annotation on " + action.getCanonicalName());
            }
            if (analyticsProvider.opcode().equalsIgnoreCase("default")) {
                logger.warn("Action " + action.getCanonicalName() + " does not specify cache token. Using default cache.");
            }
            analyticsLoader.register(new ActionMetadata(analyticsProvider.request(), action, analyticsProvider.cacheable(), analyticsProvider.opcode()));
            types.add(new NamedType(analyticsProvider.request(), analyticsProvider.opcode()));
            types.add(new NamedType(analyticsProvider.response(), analyticsProvider.opcode()));
            logger.info("Registered action: " + action.getCanonicalName());
        }
        mapper.getSubtypeResolver().registerSubtypes(types.toArray(new NamedType[types.size()]));
    }

    public static HbaseConfig createHBaseConfigWithRawKeyV1() {
        HbaseConfig hbaseConfig = new HbaseConfig();
        hbaseConfig.setRawKeyVersion("1.0");
        return hbaseConfig;
    }

    public static HbaseConfig createHBaseConfigWithRawKeyV2() {
        HbaseConfig hbaseConfig = new HbaseConfig();
        hbaseConfig.setRawKeyVersion("2.0");
        return hbaseConfig;
    }

    public static Document translatedDocumentWithRowKeyVersion1(Table table, Document document) {
        return new DocumentTranslator(TestUtils.createHBaseConfigWithRawKeyV1()).translate(table, document);
    }

    public static Document translatedDocumentWithRowKeyVersion2(Table table, Document document) {
        return new DocumentTranslator(TestUtils.createHBaseConfigWithRawKeyV2()).translate(table, document);
    }

    public static List<Document> getQueryDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, mapper));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, mapper));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, mapper));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, mapper));
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, mapper));
        return documents;
    }

    public static List<Document> getGroupDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1397658117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", 1397658117000L, new Object[]{"os", "android", "version", 3, "device", "galaxy", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", 1397658117000L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 3, "device", "nexus", "battery", 87}, mapper));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 2, "device", "galaxy", "battery", 76}, mapper));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 78}, mapper));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 56}, mapper));
        documents.add(TestUtils.getDocument("F", 1397658118005L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 35}, mapper));
        documents.add(TestUtils.getDocument("G", 1397658118006L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 44}, mapper));
        return documents;
    }

    public static List<Document> getGroupDocumentsForEstimation(ObjectMapper mapper) {
        Random random = new Random();
        return IntStream.rangeClosed(0, 2000).mapToObj(i -> Document.builder().id(UUID.randomUUID().toString()).timestamp((long)(i * 60000) + System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)).data(mapper.valueToTree((Object)ImmutableMap.builder().put((Object)"deviceId", (Object)UUID.randomUUID().toString()).put((Object)"os", (Object)(new String[]{"ios", "android", "android", "android"})[random.nextInt(2)]).put((Object)"registered", (Object)(new boolean[]{true, false, false})[random.nextInt(3)]).put((Object)"value", (Object)random.nextInt(101)).build())).build()).collect(Collectors.toList());
    }

    public static List<Document> getHistogramDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1397651117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", 1397651117000L, new Object[]{"os", "android", "version", 3, "device", "galaxy", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", 1397658117000L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 3, "device", "nexus", "battery", 87}, mapper));
        documents.add(TestUtils.getDocument("B", 1397658218001L, new Object[]{"os", "android", "version", 2, "device", "galaxy", "battery", 76}, mapper));
        documents.add(TestUtils.getDocument("C", 1398658218002L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 78}, mapper));
        documents.add(TestUtils.getDocument("D", 1397758218003L, new Object[]{"os", "ios", "version", 1, "device", "iphone", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("E", 1397958118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 56}, mapper));
        documents.add(TestUtils.getDocument("F", 1398653118005L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 35}, mapper));
        documents.add(TestUtils.getDocument("G", 1398653118006L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 44}, mapper));
        return documents;
    }

    public static List<Document> getTrendDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1397651117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", 1397651117000L, new Object[]{"os", "android", "version", 3, "device", "galaxy", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", 1397658117000L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 3, "device", "nexus", "battery", 87}, mapper));
        documents.add(TestUtils.getDocument("B", 1397658218001L, new Object[]{"os", "android", "version", 2, "device", "galaxy", "battery", 76}, mapper));
        documents.add(TestUtils.getDocument("C", 1398658218002L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 78}, mapper));
        documents.add(TestUtils.getDocument("D", 1397758218003L, new Object[]{"os", "ios", "version", 1, "device", "iphone", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("E", 1397958118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 56}, mapper));
        documents.add(TestUtils.getDocument("F", 1398653118005L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 35}, mapper));
        documents.add(TestUtils.getDocument("G", 1398653118006L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 44}, mapper));
        return documents;
    }

    public static List<Document> getStatsDocuments(ObjectMapper mapper) {
        ArrayList documents = Lists.newArrayList();
        documents.add(TestUtils.getDocument("Z", 1467282856000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 10}, mapper));
        documents.add(TestUtils.getDocument("Y", 1467331200000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 20}, mapper));
        documents.add(TestUtils.getDocument("X", 1467417600000L, new Object[]{"os", "ios", "version", 3, "device", "galaxy", "battery", 30}, mapper));
        documents.add(TestUtils.getDocument("W", 1467504000000L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 40}, mapper));
        documents.add(TestUtils.getDocument("A", 1467590400000L, new Object[]{"os", "wp", "version", 3, "device", "nexus", "battery", 50}, mapper));
        return documents;
    }

    public static List<Document> getStatsTrendDocuments(ObjectMapper mapper) {
        ArrayList documents = Lists.newArrayList();
        documents.add(TestUtils.getDocument("Z", 1467282856000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1467331200000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", 1467417600000L, new Object[]{"os", "ios", "version", 3, "device", "galaxy", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", 1467504000000L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", 1467590400000L, new Object[]{"os", "wp", "version", 3, "device", "nexus", "battery", 87}, mapper));
        return documents;
    }

    public static List<Document> getCountDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1397651117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", 1397651117000L, new Object[]{"os", "android", "version", 3, "device", "galaxy", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", 1397658117000L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 3, "device", "nexus", "battery", 87}, mapper));
        documents.add(TestUtils.getDocument("B", 1397658218001L, new Object[]{"os", "android", "version", 2, "device", "galaxy", "battery", 76}, mapper));
        documents.add(TestUtils.getDocument("C", 1398658218002L, new Object[]{"os", "android", "version", 2, "device", "nexus", "battery", 78}, mapper));
        documents.add(TestUtils.getDocument("D", 1397758218003L, new Object[]{"os", "ios", "version", 1, "device", "iphone", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("E", 1397958118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 56}, mapper));
        documents.add(TestUtils.getDocument("F", 1398653118005L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 35}, mapper));
        documents.add(TestUtils.getDocument("G", 1398653118006L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 44}, mapper));
        return documents;
    }

    public static List<Document> getDistinctDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", 1397651117000L, new Object[]{"os", "android", "version", 1, "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 3, "device", "nexus", "battery", 87}, mapper));
        documents.add(TestUtils.getDocument("D", 1397758218003L, new Object[]{"os", "ios", "version", 1, "device", "iphone", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("E", 1397958118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 56}, mapper));
        documents.add(TestUtils.getDocument("F", 1398653118005L, new Object[]{"os", "ios", "version", 2, "device", "nexus", "battery", 35}, mapper));
        documents.add(TestUtils.getDocument("G", 1398653118006L, new Object[]{"os", "ios", "version", 2, "device", "ipad", "battery", 44}, mapper));
        return documents;
    }

    public static List<Document> getMappingDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        HashMap document = Maps.newHashMap();
        document.put("word", "1234");
        document.put("data", Collections.singletonMap("data", "d"));
        document.put("header", Collections.singletonList(Collections.singletonMap("hello", "world")));
        documents.add(new Document("Z", System.currentTimeMillis(), mapper.valueToTree((Object)document)));
        document = Maps.newHashMap();
        document.put("word", "1234");
        document.put("data", Collections.singletonMap("data", "d"));
        document.put("head", Collections.singletonList(Collections.singletonMap("hello", 23)));
        documents.add(new Document("Y", System.currentTimeMillis(), mapper.valueToTree((Object)document)));
        return documents;
    }

    public static List<Document> getFieldCardinalityEstimationDocuments(ObjectMapper mapper) {
        Vector<Document> documents = new Vector<Document>();
        HashMap document = Maps.newHashMap();
        document.put("word", "1234");
        document.put("numeric", 20);
        document.put("boolean", true);
        document.put("data", Collections.singletonMap("someField", "d"));
        document.put("header", Collections.singletonList(Collections.singletonMap("someHeaderField", "client1")));
        long time = DateTime.now().minusDays(1).toDate().getTime();
        documents.add(new Document("Z", time, mapper.valueToTree((Object)document)));
        document = Maps.newHashMap();
        document.put("word", "2345");
        document.put("numeric", 30);
        document.put("boolean", true);
        document.put("data", ImmutableMap.of((Object)"someField", (Object)"c", (Object)"someOtherField", (Object)"blah", (Object)"exclusiveField", (Object)"hmmm"));
        document.put("header", Collections.singletonList(Collections.singletonMap("someHeaderField", "client1")));
        documents.add(new Document("Y", time, mapper.valueToTree((Object)document)));
        document = Maps.newHashMap();
        document.put("word", "2345");
        document.put("numeric", 25);
        document.put("boolean", false);
        document.put("data", ImmutableMap.of((Object)"someField", (Object)"c", (Object)"someOtherField", (Object)"blah"));
        document.put("header", Collections.singletonList(Collections.singletonMap("someHeaderField", "client1")));
        documents.add(new Document("X", time, mapper.valueToTree((Object)document)));
        return documents;
    }

    public static List<Document> getQueryDocumentsDifferentDate(ObjectMapper mapper, long startTimestamp) {
        Vector<Document> documents = new Vector<Document>();
        documents.add(TestUtils.getDocument("Z", startTimestamp, new Object[]{"os", "android", "device", "nexus", "battery", 24}, mapper));
        documents.add(TestUtils.getDocument("Y", startTimestamp++, new Object[]{"os", "android", "device", "nexus", "battery", 48}, mapper));
        documents.add(TestUtils.getDocument("X", startTimestamp++, new Object[]{"os", "android", "device", "nexus", "battery", 74}, mapper));
        documents.add(TestUtils.getDocument("W", startTimestamp++, new Object[]{"os", "android", "device", "nexus", "battery", 99}, mapper));
        documents.add(TestUtils.getDocument("A", startTimestamp++, new Object[]{"os", "android", "version", 1, "device", "nexus"}, mapper));
        documents.add(TestUtils.getDocument("B", startTimestamp++, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, mapper));
        documents.add(TestUtils.getDocument("C", startTimestamp++, new Object[]{"os", "android", "version", 2, "device", "nexus"}, mapper));
        documents.add(TestUtils.getDocument("D", startTimestamp++, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, mapper));
        documents.add(TestUtils.getDocument("E", startTimestamp, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, mapper));
        return documents;
    }

    public static ElasticsearchConnection initESConnection(MockElasticsearchServer elasticsearchServer) {
        CreateIndexRequest createRequest = new CreateIndexRequest("table-meta");
        Settings indexSettings = Settings.builder().put("number_of_replicas", 0).build();
        createRequest.settings(indexSettings);
        elasticsearchServer.getClient().admin().indices().create(createRequest).actionGet();
        elasticsearchServer.getClient().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().execute().actionGet();
        ElasticsearchConnection elasticsearchConnection = (ElasticsearchConnection)Mockito.mock(ElasticsearchConnection.class);
        Mockito.when((Object)elasticsearchConnection.getClient()).thenReturn((Object)elasticsearchServer.getClient());
        ElasticsearchUtils.initializeMappings((Client)elasticsearchServer.getClient());
        return elasticsearchConnection;
    }
}

