/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.MapStoreFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMapStore
implements MapStore<String, Table> {
    private static final Logger logger = LoggerFactory.getLogger((String)TableMapStore.class.getSimpleName());
    public static final String TABLE_META_INDEX = "table-meta";
    public static final String TABLE_META_TYPE = "table-meta";
    private final ElasticsearchConnection elasticsearchConnection;
    private final ObjectMapper objectMapper;

    public static Factory factory(ElasticsearchConnection elasticsearchConnection) {
        return new Factory(elasticsearchConnection);
    }

    public TableMapStore(ElasticsearchConnection elasticsearchConnection) {
        this.elasticsearchConnection = elasticsearchConnection;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public void store(String key, Table value) {
        if (key == null || value == null || value.getName() == null) {
            throw new RuntimeException(String.format("Illegal Store Request - %s - %s", key, value));
        }
        logger.info("Storing key: " + key);
        try {
            ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchConnection.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setConsistencyLevel(WriteConsistencyLevel.ALL)).setSource(this.objectMapper.writeValueAsString((Object)value)).setId(key).setRefresh(true).execute().actionGet();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error saving meta: ", e);
        }
    }

    public void storeAll(Map<String, Table> map) {
        if (map == null) {
            throw new RuntimeException("Illegal Store Request - Null Map");
        }
        if (map.containsKey(null)) {
            throw new RuntimeException("Illegal Store Request - Null Key is Present");
        }
        logger.info("Store all called for multiple values");
        BulkRequestBuilder bulkRequestBuilder = this.elasticsearchConnection.getClient().prepareBulk().setConsistencyLevel(WriteConsistencyLevel.ALL).setRefresh(true);
        for (Map.Entry<String, Table> mapEntry : map.entrySet()) {
            try {
                if (mapEntry.getValue() == null) {
                    throw new RuntimeException(String.format("Illegal Store Request - Object is Null for Table - %s", mapEntry.getKey()));
                }
                bulkRequestBuilder.add(this.elasticsearchConnection.getClient().prepareIndex("table-meta", "table-meta", mapEntry.getKey()).setSource(this.objectMapper.writeValueAsString((Object)mapEntry.getValue())));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error bulk saving meta: ", e);
            }
        }
        bulkRequestBuilder.execute().actionGet();
    }

    public void delete(String key) {
        logger.info("Delete called for value: " + key);
        ((DeleteRequestBuilder)((DeleteRequestBuilder)this.elasticsearchConnection.getClient().prepareDelete().setConsistencyLevel(WriteConsistencyLevel.ALL)).setRefresh(true).setIndex("table-meta")).setType("table-meta").setId(key).execute().actionGet();
        logger.info("Deleted value: " + key);
    }

    public void deleteAll(Collection<String> keys) {
        logger.info(String.format("Delete all called for multiple values: %s", keys));
        BulkRequestBuilder bulRequestBuilder = this.elasticsearchConnection.getClient().prepareBulk().setConsistencyLevel(WriteConsistencyLevel.ALL).setRefresh(true);
        for (String key : keys) {
            bulRequestBuilder.add(this.elasticsearchConnection.getClient().prepareDelete("table-meta", "table-meta", key));
        }
        bulRequestBuilder.execute().actionGet();
        logger.info(String.format("Deleted multiple values: %s", keys));
    }

    public Table load(String key) {
        logger.info("Load called for: " + key);
        GetResponse response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(key).execute().actionGet();
        if (!response.isExists()) {
            return null;
        }
        try {
            return (Table)this.objectMapper.readValue(response.getSourceAsBytes(), Table.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting data for table: " + key);
        }
    }

    public Map<String, Table> loadAll(Collection<String> keys) {
        logger.info("Load all called for multiple keys");
        MultiGetResponse response = (MultiGetResponse)this.elasticsearchConnection.getClient().prepareMultiGet().add("table-meta", "table-meta", keys).execute().actionGet();
        HashMap tables = Maps.newHashMap();
        for (MultiGetItemResponse multiGetItemResponse : response) {
            try {
                Table table = (Table)this.objectMapper.readValue(multiGetItemResponse.getResponse().getSourceAsString(), Table.class);
                tables.put(table.getName(), table);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting data for table: " + multiGetItemResponse.getId());
            }
        }
        logger.info("Loaded value count: " + tables.size());
        return tables;
    }

    public Set<String> loadAllKeys() {
        logger.info("Load all keys called");
        SearchResponse response = (SearchResponse)this.elasticsearchConnection.getClient().prepareSearch(new String[]{"table-meta"}).setTypes(new String[]{"table-meta"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSearchType(SearchType.SCAN).setScroll(new TimeValue(30L, TimeUnit.SECONDS)).setNoFields().execute().actionGet();
        HashSet ids = Sets.newHashSet();
        do {
            response = (SearchResponse)this.elasticsearchConnection.getClient().prepareSearchScroll(response.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet();
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                ids.add(hit.getId());
            }
        } while (0 != response.getHits().hits().length);
        logger.info("Loaded value count: " + ids.size());
        return ids;
    }

    public static class Factory
    implements MapStoreFactory<String, Table> {
        private final ElasticsearchConnection elasticsearchConnection;

        public Factory(ElasticsearchConnection elasticsearchConnection) {
            this.elasticsearchConnection = elasticsearchConnection;
        }

        public TableMapStore newMapStore(String mapName, Properties properties) {
            return new TableMapStore(this.elasticsearchConnection);
        }
    }
}

