/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.ActionMetadata;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.google.common.collect.Maps;
import io.dropwizard.lifecycle.Managed;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsLoader
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsLoader.class);
    private final Map<String, ActionMetadata> actions = Maps.newHashMap();
    private final TableMetadataManager tableMetadataManager;
    private final DataStore dataStore;
    private final QueryStore queryStore;
    private final ElasticsearchConnection elasticsearchConnection;
    private final CacheManager cacheManager;
    private final ObjectMapper objectMapper;

    public AnalyticsLoader(TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection elasticsearchConnection, CacheManager cacheManager, ObjectMapper objectMapper) {
        this.tableMetadataManager = tableMetadataManager;
        this.dataStore = dataStore;
        this.queryStore = queryStore;
        this.elasticsearchConnection = elasticsearchConnection;
        this.cacheManager = cacheManager;
        this.objectMapper = objectMapper;
    }

    public <R extends ActionRequest> Action<R> getAction(R request) throws Exception {
        ActionMetadata metadata;
        String className = request.getClass().getCanonicalName();
        if (this.actions.containsKey(className) && (metadata = this.actions.get(className)).getRequest().isInstance(request)) {
            ActionRequest r = metadata.getRequest().cast(request);
            Constructor<? extends Action> constructor = metadata.getAction().getConstructor(metadata.getRequest(), TableMetadataManager.class, DataStore.class, QueryStore.class, ElasticsearchConnection.class, String.class, CacheManager.class, ObjectMapper.class);
            return constructor.newInstance(r, this.tableMetadataManager, this.dataStore, this.queryStore, this.elasticsearchConnection, metadata.getCacheToken(), this.cacheManager, this.objectMapper);
        }
        return null;
    }

    public void register(ActionMetadata actionMetadata) {
        this.actions.put(actionMetadata.getRequest().getCanonicalName(), actionMetadata);
        if (actionMetadata.isCacheable()) {
            this.cacheManager.create(actionMetadata.getCacheToken());
        }
    }

    public void start() throws Exception {
        Reflections reflections = new Reflections("com.flipkart.foxtrot", new Scanner[]{new SubTypesScanner()});
        Set actions = reflections.getSubTypesOf(Action.class);
        if (actions.isEmpty()) {
            throw new Exception("No analytics actions found!!");
        }
        ArrayList<NamedType> types = new ArrayList<NamedType>();
        for (Class action : actions) {
            AnalyticsProvider analyticsProvider = action.getAnnotation(AnalyticsProvider.class);
            if (null == analyticsProvider.request() || null == analyticsProvider.opcode() || analyticsProvider.opcode().isEmpty() || null == analyticsProvider.response()) {
                throw new Exception("Invalid annotation on " + action.getCanonicalName());
            }
            if (analyticsProvider.opcode().equalsIgnoreCase("default")) {
                logger.warn("Action " + action.getCanonicalName() + " does not specify cache token. Using default cache.");
            }
            this.register(new ActionMetadata(analyticsProvider.request(), action, analyticsProvider.cacheable(), analyticsProvider.opcode()));
            types.add(new NamedType(analyticsProvider.request(), analyticsProvider.opcode()));
            types.add(new NamedType(analyticsProvider.response(), analyticsProvider.opcode()));
            logger.info("Registered action: " + action.getCanonicalName());
        }
        this.objectMapper.getSubtypeResolver().registerSubtypes(types.toArray(new NamedType[types.size()]));
    }

    public void stop() throws Exception {
    }
}

