/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.distinct.DistinctRequest;
import com.flipkart.foxtrot.common.distinct.DistinctResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyticsProvider(opcode="distinct", request=DistinctRequest.class, response=DistinctResponse.class, cacheable=true)
public class DistinctAction
extends Action<DistinctRequest> {
    private static final Logger logger = LoggerFactory.getLogger(DistinctAction.class);

    public DistinctAction(DistinctRequest parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        super(parameter, tableMetadataManager, dataStore, queryStore, connection, cacheToken, cacheManager, objectMapper);
    }

    @Override
    protected void preprocess() {
        ((DistinctRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((DistinctRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((DistinctRequest)this.getParameter()).getTable();
    }

    @Override
    protected String getRequestCacheKey() {
        long filterHashKey = 0L;
        DistinctRequest query = (DistinctRequest)this.getParameter();
        if (null != query.getFilters()) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        for (int i = 0; i < query.getNesting().size(); ++i) {
            filterHashKey += (long)(31 * ((ResultSort)query.getNesting().get(i)).hashCode() * (i + 1));
        }
        return String.format("%s-%d", query.getTable(), filterHashKey);
    }

    @Override
    public void validateImpl(DistinctRequest parameter) throws MalformedQueryException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((Collection)parameter.getNesting())) {
            validationErrors.add("At least one nesting parameter is required");
        } else {
            for (ResultSort resultSort : parameter.getNesting()) {
                if (resultSort == null) {
                    validationErrors.add("nested parameter cannot be null");
                    continue;
                }
                if (CollectionUtils.isNullOrEmpty((String)resultSort.getField())) {
                    validationErrors.add("nested parameter cannot have null name");
                }
                if (resultSort.getOrder() != null) continue;
                validationErrors.add("nested parameter cannot have null sorting order");
            }
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public ActionResponse execute(DistinctRequest request) throws FoxtrotException {
        SearchRequestBuilder query;
        try {
            query = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(request.getTable(), (ActionRequest)request)).setIndicesOptions(Utils.indicesOptions());
            TermsBuilder rootBuilder = null;
            TermsBuilder termsBuilder = null;
            for (ResultSort nestedField : request.getNesting()) {
                Terms.Order order;
                String aggregationKey = Utils.sanitizeFieldForAggregation(nestedField.getField());
                Terms.Order order2 = order = nestedField.getOrder() == ResultSort.Order.desc ? Terms.Order.term((boolean)false) : Terms.Order.term((boolean)true);
                if (null == termsBuilder) {
                    termsBuilder = ((TermsBuilder)AggregationBuilders.terms((String)aggregationKey).field(nestedField.getField())).order(order);
                } else {
                    TermsBuilder tempBuilder = ((TermsBuilder)AggregationBuilders.terms((String)aggregationKey).field(nestedField.getField())).order(order);
                    termsBuilder.subAggregation((AbstractAggregationBuilder)tempBuilder);
                    termsBuilder = tempBuilder;
                }
                termsBuilder.size(0);
                if (null != rootBuilder) continue;
                rootBuilder = termsBuilder;
            }
            query.setQuery(new ElasticSearchQueryGenerator().genFilter(request.getFilters())).setSize(0).addAggregation(rootBuilder);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)request, e);
        }
        try {
            SearchResponse response = (SearchResponse)query.execute().actionGet(this.getGetQueryTimeout());
            Aggregations aggregations = response.getAggregations();
            if (aggregations == null) {
                logger.error("Null response for Group. Request : " + request.toString());
                return new DistinctResponse(new ArrayList(), new ArrayList());
            }
            return this.getDistinctResponse(request, aggregations);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)request, (Exception)((Object)e));
        }
    }

    private DistinctResponse getDistinctResponse(DistinctRequest request, Aggregations aggregations) {
        DistinctResponse response = new DistinctResponse();
        List<String> headerList = request.getNesting().stream().map(ResultSort::getField).collect(Collectors.toList());
        response.setHeaders(headerList);
        ArrayList<List<String>> responseList = new ArrayList<List<String>>();
        this.flatten(null, headerList, responseList, aggregations);
        response.setResult(responseList);
        return response;
    }

    private void flatten(String parentKey, List<String> fields, List<List<String>> responseList, Aggregations aggregations) {
        String field = fields.get(0);
        ArrayList<String> remainingFields = fields.size() > 1 ? fields.subList(1, fields.size()) : new ArrayList<String>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (fields.size() == 1) {
                responseList.add(this.getValueList(parentKey, String.valueOf(bucket.getKey())));
                continue;
            }
            this.flatten(this.getProperKey(parentKey, String.valueOf(bucket.getKey())), remainingFields, responseList, bucket.getAggregations());
        }
    }

    private String getProperKey(String parentKey, String currentKey) {
        return parentKey == null ? currentKey : parentKey + "_--&--_" + currentKey;
    }

    private List<String> getValueList(String parentKey, String currentKey) {
        String finalValue = this.getProperKey(parentKey, currentKey);
        String[] valuesList = finalValue.split("_--&--_");
        return Arrays.asList(valuesList);
    }
}

