/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.jobs;

import com.flipkart.foxtrot.core.jobs.BaseJobConfig;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import io.dropwizard.lifecycle.Managed;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import net.javacrumbs.shedlock.provider.hazelcast.HazelcastLockProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJobManager
implements Managed {
    private static final int MAX_TIME_TO_RUN_TASK_IN_MINUTES = 120;
    private static final String TIME_ZONE = "Asia/Kolkata";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BaseJobManager.class.getSimpleName());
    private final BaseJobConfig baseJobConfig;
    private final ScheduledExecutorService scheduledExecutorService;
    private final HazelcastConnection hazelcastConnection;

    public BaseJobManager(BaseJobConfig baseJobConfig, ScheduledExecutorService scheduledExecutorService, HazelcastConnection hazelcastConnection) {
        this.baseJobConfig = baseJobConfig;
        this.scheduledExecutorService = scheduledExecutorService;
        this.hazelcastConnection = hazelcastConnection;
    }

    public void start() {
        ZonedDateTime timeToRunJob;
        ZoneId currentZone;
        ZonedDateTime zonedNow;
        LOGGER.info(String.format("Starting %s Manager", this.baseJobConfig.getJobName()));
        if (!this.baseJobConfig.isActive()) {
            LOGGER.info(String.format("Config is not active. Hence, aborting the %s job", this.baseJobConfig.getJobName()));
        }
        LOGGER.info(String.format("Scheduling %s Job", this.baseJobConfig.getJobName()));
        LocalDateTime localNow = LocalDateTime.now();
        Calendar now = Calendar.getInstance();
        String timeZone = now.getTimeZone().getID();
        if (StringUtils.isEmpty((CharSequence)timeZone)) {
            timeZone = TIME_ZONE;
        }
        if ((zonedNow = ZonedDateTime.of(localNow, currentZone = ZoneId.of(timeZone))).compareTo(timeToRunJob = zonedNow.withHour(this.baseJobConfig.getInitialDelay()).withMinute(0).withSecond(0)) > 0) {
            timeToRunJob = timeToRunJob.plusDays(1L);
        }
        Duration duration = Duration.between(zonedNow, timeToRunJob);
        long initialDelay = duration.getSeconds();
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                DefaultLockingTaskExecutor executor = new DefaultLockingTaskExecutor((LockProvider)new HazelcastLockProvider(this.hazelcastConnection.getHazelcast()));
                int maxTimeToRunJob = 120;
                if (this.baseJobConfig.getMaxTimeToRunJobInMinutes() != 0) {
                    maxTimeToRunJob = this.baseJobConfig.getMaxTimeToRunJobInMinutes();
                }
                Instant lockAtMostUntil = Instant.now().plusSeconds(TimeUnit.MINUTES.toSeconds(maxTimeToRunJob));
                this.runImpl((LockingTaskExecutor)executor, lockAtMostUntil);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while running the job : ", (Throwable)e);
            }
        }, initialDelay, this.baseJobConfig.getInterval(), TimeUnit.SECONDS);
        LOGGER.info(String.format("Scheduled %s Job", this.baseJobConfig.getJobName()));
    }

    public void stop() {
        LOGGER.info(String.format("Stopped  %s Job Manager", this.baseJobConfig.getJobName()));
    }

    protected abstract void runImpl(LockingTaskExecutor var1, Instant var2);
}

