/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.exception;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CardinalityOverflowException
extends MalformedQueryException {
    private static final long serialVersionUID = -8591567152701424689L;
    private String field;
    private double probability;

    protected CardinalityOverflowException(ActionRequest actionRequest, String field, double probability) {
        super(ErrorCode.CARDINALITY_OVERFLOW, actionRequest, Collections.singletonList("Query blocked as probability > 0.5"));
        this.field = field;
        this.probability = probability;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap map = Maps.newHashMap();
        map.put("request", super.getActionRequest());
        map.put("field", this.field);
        map.put("probability", this.probability);
        return map;
    }

    public String getField() {
        return this.field;
    }

    public double getProbability() {
        return this.probability;
    }
}

