/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cache.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.core.cache.Cache;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.hazelcast.core.IMap;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCache
implements Cache {
    private static final Logger logger = LoggerFactory.getLogger((String)DistributedCache.class.getSimpleName());
    private final IMap<String, String> distributedMap;
    private final ObjectMapper mapper;

    public DistributedCache(HazelcastConnection hazelcastConnection, String name, ObjectMapper mapper) {
        this.distributedMap = hazelcastConnection.getHazelcast().getMap("cache-for-" + name);
        this.mapper = mapper;
    }

    @Override
    public ActionResponse put(String key, ActionResponse data) {
        try {
            String serializedData = this.mapper.writeValueAsString((Object)data);
            if (serializedData != null) {
                if (serializedData.length() <= 32768) {
                    this.distributedMap.put((Object)key, (Object)this.mapper.writeValueAsString((Object)data));
                } else {
                    logger.error(String.format("Size of response is too big for cache. Skipping it. Response Part : %s", serializedData.substring(0, 1024)));
                }
            }
        }
        catch (JsonProcessingException e) {
            logger.error("Error saving value to map: ", (Throwable)e);
        }
        return data;
    }

    @Override
    public ActionResponse get(String key) {
        if (null == key) {
            return null;
        }
        String data = (String)this.distributedMap.get((Object)key);
        if (null != data) {
            try {
                return (ActionResponse)this.mapper.readValue(data, ActionResponse.class);
            }
            catch (IOException e) {
                logger.error("Error deserializing: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean has(String key) {
        return null != key && this.distributedMap.containsKey((Object)key);
    }
}

