/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.FieldMetadata;
import com.flipkart.foxtrot.common.FieldType;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.common.estimation.EstimationDataType;
import com.flipkart.foxtrot.core.MockElasticsearchServer;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchQueryStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.DistributedTableMetadataManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ElasticsearchQueryStoreTest {
    private static final ObjectMapper mapper = new ObjectMapper();
    private MockElasticsearchServer elasticsearchServer;
    private DataStore dataStore;
    private ElasticsearchQueryStore queryStore;
    private TableMetadataManager tableMetadataManager;
    private HazelcastInstance hazelcastInstance;

    @Before
    public void setUp() throws Exception {
        this.dataStore = (DataStore)Mockito.mock(DataStore.class);
        this.elasticsearchServer = new MockElasticsearchServer(UUID.randomUUID().toString());
        ElasticsearchConnection elasticsearchConnection = (ElasticsearchConnection)Mockito.mock(ElasticsearchConnection.class);
        Mockito.when((Object)elasticsearchConnection.getClient()).thenReturn((Object)this.elasticsearchServer.getClient());
        ElasticsearchUtils.initializeMappings((Client)elasticsearchConnection.getClient());
        this.hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)this.hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)new Config());
        hazelcastConnection.start();
        CardinalityConfig cardinalityConfig = new CardinalityConfig("true", String.valueOf(50));
        this.tableMetadataManager = new DistributedTableMetadataManager(hazelcastConnection, elasticsearchConnection, mapper, cardinalityConfig);
        this.tableMetadataManager.start();
        this.tableMetadataManager.save(Table.builder().name("test-table").ttl(30).build());
        this.queryStore = new ElasticsearchQueryStore(this.tableMetadataManager, elasticsearchConnection, this.dataStore, mapper, cardinalityConfig);
    }

    @After
    public void tearDown() throws Exception {
        this.elasticsearchServer.shutdown();
        this.hazelcastInstance.shutdown();
    }

    @Test
    public void testSaveSingleRawKeyVersion1() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        Document originalDocument = this.createDummyDocument();
        Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion1(table, originalDocument);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).save(table, originalDocument);
        this.queryStore.save("test-table", originalDocument);
        GetResponse getResponse = (GetResponse)this.elasticsearchServer.getClient().prepareGet(ElasticsearchUtils.getCurrentIndex((String)"test-table", (long)originalDocument.getTimestamp()), "document", originalDocument.getId()).setFields(new String[]{"_timestamp"}).execute().actionGet();
        Assert.assertTrue((String)"Id should exist in ES", (boolean)getResponse.isExists());
        Assert.assertEquals((String)"Id should match requestId", (Object)originalDocument.getId(), (Object)getResponse.getId());
        Assert.assertEquals((String)"Timestamp should match request timestamp", (Object)originalDocument.getTimestamp(), (Object)getResponse.getField("_timestamp").getValue());
    }

    @Test
    public void testSaveSingleRawKeyVersion2() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        Document originalDocument = this.createDummyDocument();
        Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion2(table, originalDocument);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).save(table, originalDocument);
        this.queryStore.save("test-table", originalDocument);
        GetResponse getResponse = (GetResponse)this.elasticsearchServer.getClient().prepareGet(ElasticsearchUtils.getCurrentIndex((String)"test-table", (long)originalDocument.getTimestamp()), "document", translatedDocument.getId()).setFields(new String[]{"_timestamp"}).execute().actionGet();
        Assert.assertTrue((String)"Id should exist in ES", (boolean)getResponse.isExists());
        Assert.assertEquals((String)"Id should match requestId", (Object)translatedDocument.getId(), (Object)getResponse.getId());
        Assert.assertEquals((String)"Timestamp should match request timestamp", (Object)originalDocument.getTimestamp(), (Object)getResponse.getField("_timestamp").getValue());
    }

    @Test
    public void testSaveSingleInvalidTable() throws Exception {
        Document expectedDocument = this.createDummyDocument();
        try {
            this.queryStore.save(TestUtils.TEST_TABLE + "-missing", expectedDocument);
            Assert.fail();
        }
        catch (FoxtrotException qse) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)qse.getCode());
        }
    }

    @Test
    public void testSaveBulkRawKeyVersion1() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        ArrayList documents = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        ArrayList translatedDocuments = Lists.newArrayList();
        translatedDocuments.addAll(documents.stream().map(document -> TestUtils.translatedDocumentWithRowKeyVersion1(table, document)).collect(Collectors.toList()));
        ((DataStore)Mockito.doReturn((Object)translatedDocuments).when((Object)this.dataStore)).saveAll(table, (List)documents);
        this.queryStore.save("test-table", (List)documents);
        for (Document document2 : documents) {
            GetResponse getResponse = (GetResponse)this.elasticsearchServer.getClient().prepareGet(ElasticsearchUtils.getCurrentIndex((String)"test-table", (long)document2.getTimestamp()), "document", document2.getId()).setFields(new String[]{"_timestamp"}).execute().actionGet();
            Assert.assertTrue((String)"Id should exist in ES", (boolean)getResponse.isExists());
            Assert.assertEquals((String)"Id should match requestId", (Object)document2.getId(), (Object)getResponse.getId());
            Assert.assertEquals((String)"Timestamp should match request timestamp", (Object)document2.getTimestamp(), (Object)getResponse.getField("_timestamp").getValue());
        }
    }

    @Test
    public void testSaveBulkRawKeyVersion2() throws Exception {
        GetResponse getResponse;
        Table table = this.tableMetadataManager.get("test-table");
        ArrayList documents = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        ArrayList translatedDocuments = Lists.newArrayList();
        translatedDocuments.addAll(documents.stream().map(document -> TestUtils.translatedDocumentWithRowKeyVersion2(table, document)).collect(Collectors.toList()));
        ((DataStore)Mockito.doReturn((Object)translatedDocuments).when((Object)this.dataStore)).saveAll(table, (List)documents);
        this.queryStore.save("test-table", (List)documents);
        for (Document document2 : documents) {
            getResponse = (GetResponse)this.elasticsearchServer.getClient().prepareGet(ElasticsearchUtils.getCurrentIndex((String)"test-table", (long)document2.getTimestamp()), "document", document2.getId()).setFields(new String[]{"_timestamp"}).execute().actionGet();
            Assert.assertFalse((String)"Id should not exist in ES", (boolean)getResponse.isExists());
        }
        for (Document document2 : translatedDocuments) {
            getResponse = (GetResponse)this.elasticsearchServer.getClient().prepareGet(ElasticsearchUtils.getCurrentIndex((String)"test-table", (long)document2.getTimestamp()), "document", document2.getId()).setFields(new String[]{"_timestamp"}).execute().actionGet();
            Assert.assertTrue((String)"Id should exist in ES", (boolean)getResponse.isExists());
            Assert.assertEquals((String)"Id should match requestId", (Object)document2.getId(), (Object)getResponse.getId());
            Assert.assertEquals((String)"Timestamp should match request timestamp", (Object)document2.getTimestamp(), (Object)getResponse.getField("_timestamp").getValue());
        }
    }

    @Test
    public void testSaveBulkNullList() throws Exception {
        List list = null;
        try {
            this.queryStore.save("test-table", list);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveBulkEmptyList() throws Exception {
        Vector list = new Vector();
        try {
            this.queryStore.save("test-table", list);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)ex.getCode());
        }
    }

    @Test
    public void testSaveBulkInvalidTable() throws Exception {
        Vector<Document> documents = new Vector<Document>();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        try {
            this.queryStore.save(TestUtils.TEST_TABLE + "-missing", documents);
            Assert.fail();
        }
        catch (FoxtrotException qse) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)qse.getCode());
        }
    }

    @Test
    public void testGetSingleRawKeyVersion1() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        Document document = this.createDummyDocument();
        Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion1(table, document);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).save(table, document);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).get(table, document.getId());
        this.queryStore.save("test-table", document);
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        Document responseDocument = this.queryStore.get("test-table", document.getId());
        Assert.assertNotNull((Object)responseDocument);
        Assert.assertEquals((Object)document.getId(), (Object)responseDocument.getId());
        Assert.assertEquals((String)"Timestamp should match request timestamp", (long)document.getTimestamp(), (long)responseDocument.getTimestamp());
    }

    @Test
    public void testGetSingleRawKeyVersion2() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        Document document = this.createDummyDocument();
        Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion2(table, document);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).save(table, document);
        ((DataStore)Mockito.doReturn((Object)document).when((Object)this.dataStore)).get(table, translatedDocument.getId());
        this.queryStore.save("test-table", document);
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        Document responseDocument = this.queryStore.get("test-table", document.getId());
        Assert.assertNotNull((Object)responseDocument);
        Assert.assertEquals((Object)document.getId(), (Object)responseDocument.getId());
        Assert.assertEquals((String)"Timestamp should match request timestamp", (long)document.getTimestamp(), (long)responseDocument.getTimestamp());
    }

    @Test
    public void testGetSingleInvalidId() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        ((DataStore)Mockito.doThrow((Throwable[])new Throwable[]{FoxtrotExceptions.createMissingDocumentException((Table)table, (String)UUID.randomUUID().toString())}).when((Object)this.dataStore)).get((Table)Matchers.any(Table.class), Matchers.anyString());
        try {
            this.queryStore.get("test-table", UUID.randomUUID().toString());
            Assert.fail();
        }
        catch (FoxtrotException dse) {
            Assert.assertEquals((Object)ErrorCode.DOCUMENT_NOT_FOUND, (Object)dse.getCode());
        }
    }

    @Test
    public void testGetBulkRawKeyVersion1() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        LinkedHashMap idValues = Maps.newLinkedHashMap();
        LinkedHashMap translatedIdValues = Maps.newLinkedHashMap();
        Vector<String> ids = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            Document document = this.createDummyDocument();
            Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion1(table, document);
            ids.add(document.getId());
            idValues.put(document.getId(), document);
            translatedIdValues.put(document.getId(), translatedDocument);
        }
        ((DataStore)Mockito.doReturn((Object)ImmutableList.copyOf(translatedIdValues.values())).when((Object)this.dataStore)).saveAll(table, (List)ImmutableList.copyOf(idValues.values()));
        ((DataStore)Mockito.doReturn((Object)ImmutableList.copyOf(idValues.values())).when((Object)this.dataStore)).getAll(table, ids);
        this.queryStore.save("test-table", (List)ImmutableList.copyOf(idValues.values()));
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        List responseDocuments = this.queryStore.getAll("test-table", ids);
        HashMap responseIdValues = Maps.newHashMap();
        for (Document doc : responseDocuments) {
            responseIdValues.put(doc.getId(), doc);
        }
        Assert.assertNotNull((String)"List of returned Documents should not be null", (Object)responseDocuments);
        for (String id : ids) {
            Assert.assertTrue((String)"Requested Id should be present in response", (boolean)responseIdValues.containsKey(id));
            Assert.assertNotNull(responseIdValues.get(id));
            Assert.assertEquals((Object)id, (Object)((Document)responseIdValues.get(id)).getId());
            Assert.assertEquals((String)"Timestamp should match request timestamp", (long)((Document)idValues.get(id)).getTimestamp(), (long)((Document)responseIdValues.get(id)).getTimestamp());
        }
    }

    @Test
    public void testGetBulkRawKeyVersion2() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        LinkedHashMap idValues = Maps.newLinkedHashMap();
        LinkedHashMap translatedIdValues = Maps.newLinkedHashMap();
        ArrayList ids = Lists.newArrayList();
        ArrayList translatedIds = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            Document document = this.createDummyDocument();
            Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion2(table, document);
            ids.add(document.getId());
            translatedIds.add(translatedDocument.getId());
            idValues.put(document.getId(), document);
            translatedIdValues.put(document.getId(), translatedDocument);
        }
        ((DataStore)Mockito.doReturn((Object)ImmutableList.copyOf(translatedIdValues.values())).when((Object)this.dataStore)).saveAll(table, (List)ImmutableList.copyOf(idValues.values()));
        ((DataStore)Mockito.doReturn((Object)ImmutableList.copyOf(idValues.values())).when((Object)this.dataStore)).getAll(table, (List)translatedIds);
        this.queryStore.save("test-table", (List)ImmutableList.copyOf(idValues.values()));
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        List responseDocuments = this.queryStore.getAll("test-table", (List)ids);
        HashMap responseIdValues = Maps.newHashMap();
        for (Document doc : responseDocuments) {
            responseIdValues.put(doc.getId(), doc);
        }
        Assert.assertNotNull((String)"List of returned Documents should not be null", (Object)responseDocuments);
        for (String id : ids) {
            Assert.assertTrue((String)"Requested Id should be present in response", (boolean)responseIdValues.containsKey(id));
            Assert.assertNotNull(responseIdValues.get(id));
            Assert.assertEquals((Object)id, (Object)((Document)responseIdValues.get(id)).getId());
            Assert.assertEquals((String)"Timestamp should match request timestamp", (long)((Document)idValues.get(id)).getTimestamp(), (long)((Document)responseIdValues.get(id)).getTimestamp());
        }
    }

    @Test
    public void testGetBulkInvalidIds() throws Exception {
        Table table = this.tableMetadataManager.get("test-table");
        ((DataStore)Mockito.doThrow((Throwable[])new Throwable[]{FoxtrotExceptions.createMissingDocumentException((Table)table, (String)UUID.randomUUID().toString())}).when((Object)this.dataStore)).getAll((Table)Matchers.any(Table.class), Mockito.anyListOf(String.class));
        try {
            this.queryStore.getAll("test-table", Arrays.asList(UUID.randomUUID().toString(), UUID.randomUUID().toString()));
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.DOCUMENT_NOT_FOUND, (Object)e.getCode());
        }
    }

    @Test
    public void testGetFieldMappings() throws FoxtrotException, InterruptedException {
        ((DataStore)Mockito.doReturn(TestUtils.getMappingDocuments(mapper)).when((Object)this.dataStore)).saveAll((Table)Matchers.any(Table.class), Mockito.anyListOf(Document.class));
        this.queryStore.save("test-table", TestUtils.getMappingDocuments(mapper));
        Thread.sleep(500L);
        HashSet<FieldMetadata> mappings = new HashSet<FieldMetadata>();
        mappings.add(FieldMetadata.builder().field("time").type(FieldType.LONG).build());
        mappings.add(FieldMetadata.builder().field("word").type(FieldType.STRING).build());
        mappings.add(FieldMetadata.builder().field("data.data").type(FieldType.STRING).build());
        mappings.add(FieldMetadata.builder().field("header.hello").type(FieldType.STRING).build());
        mappings.add(FieldMetadata.builder().field("head.hello").type(FieldType.LONG).build());
        TableFieldMapping tableFieldMapping = new TableFieldMapping("test-table", mappings);
        TableFieldMapping responseMapping = this.queryStore.getFieldMappings("test-table");
        Assert.assertEquals((Object)tableFieldMapping.getTable(), (Object)responseMapping.getTable());
        Assert.assertTrue((boolean)tableFieldMapping.getMappings().equals(responseMapping.getMappings()));
    }

    @Test
    public void testGetFieldMappingsNonExistingTable() throws FoxtrotException {
        try {
            this.queryStore.getFieldMappings(TestUtils.TEST_TABLE + "-test");
            Assert.fail();
        }
        catch (FoxtrotException qse) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)qse.getCode());
        }
    }

    @Test
    public void testGetFieldMappingsNoDocumentsInTable() throws FoxtrotException {
        TableFieldMapping request = new TableFieldMapping("test-table", new HashSet());
        TableFieldMapping response = this.queryStore.getFieldMappings("test-table");
        Assert.assertEquals((Object)request.getTable(), (Object)response.getTable());
        Assert.assertTrue((boolean)request.getMappings().equals(response.getMappings()));
    }

    @Test
    public void testEsClusterHealth() throws ExecutionException, InterruptedException, FoxtrotException {
        ArrayList documents = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        ((DataStore)Mockito.doReturn((Object)documents).when((Object)this.dataStore)).saveAll((Table)Matchers.any(Table.class), Mockito.anyListOf(Document.class));
        this.queryStore.save("test-table", (List)documents);
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        ClusterHealthResponse clusterHealth = this.queryStore.getClusterHealth();
        Assert.assertEquals((Object)"elasticsearch", (Object)clusterHealth.getClusterName());
        Assert.assertEquals((long)1L, (long)clusterHealth.getIndices().size());
    }

    @Test
    public void testEsNodesStats() throws FoxtrotException, ExecutionException, InterruptedException {
        ArrayList documents = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        ((DataStore)Mockito.doReturn((Object)documents).when((Object)this.dataStore)).saveAll((Table)Matchers.any(Table.class), Mockito.anyListOf(Document.class));
        this.queryStore.save("test-table", (List)documents);
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        NodesStatsResponse clusterHealth = this.queryStore.getNodeStats();
        Assert.assertNotNull((Object)clusterHealth);
        Assert.assertEquals((long)1L, (long)clusterHealth.getNodesMap().size());
    }

    @Test
    public void testIndicesStats() throws FoxtrotException, ExecutionException, InterruptedException {
        ArrayList documents = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            documents.add(this.createDummyDocument());
        }
        ((DataStore)Mockito.doReturn((Object)documents).when((Object)this.dataStore)).saveAll((Table)Matchers.any(Table.class), Mockito.anyListOf(Document.class));
        this.queryStore.save("test-table", (List)documents);
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        IndicesStatsResponse clusterHealth = this.queryStore.getIndicesStats();
        Assert.assertEquals((long)10L, (long)clusterHealth.getPrimaries().getDocs().getCount());
        Assert.assertNotEquals((long)0L, (long)clusterHealth.getTotal().getStore().getSizeInBytes());
        Assert.assertNotEquals((long)0L, (long)clusterHealth.getPrimaries().getStore().getSizeInBytes());
    }

    @Test
    @Ignore
    public void testEstimation() throws Exception {
        ((DataStore)Mockito.doReturn(TestUtils.getFieldCardinalityEstimationDocuments(mapper)).when((Object)this.dataStore)).saveAll((Table)Matchers.any(Table.class), Mockito.anyListOf(Document.class));
        this.queryStore.save(TestUtils.TEST_TABLE.getName(), TestUtils.getFieldCardinalityEstimationDocuments(mapper));
        this.elasticsearchServer.refresh(ElasticsearchUtils.getIndices((String)"test-table"));
        TableFieldMapping mappings = this.queryStore.getFieldMappings("test-table");
        Assert.assertNotNull((Object)mappings);
        Assert.assertTrue((mappings.getMappings().stream().filter(fieldMetadata -> fieldMetadata.getType().equals((Object)FieldType.BOOLEAN)).filter(fieldMetadata -> fieldMetadata.getEstimationData() != null && fieldMetadata.getEstimationData().getType().equals((Object)EstimationDataType.FIXED)).count() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((mappings.getMappings().stream().filter(fieldMetadata -> fieldMetadata.getType().equals((Object)FieldType.LONG)).filter(fieldMetadata -> fieldMetadata.getEstimationData() != null && fieldMetadata.getEstimationData().getType().equals((Object)EstimationDataType.PERCENTILE)).count() == 2L ? 1 : 0) != 0);
        long numStringFields = mappings.getMappings().stream().filter(fieldMetadata -> fieldMetadata.getType().equals((Object)FieldType.STRING)).count();
        Assert.assertTrue((mappings.getMappings().stream().filter(fieldMetadata -> fieldMetadata.getType().equals((Object)FieldType.STRING)).filter(fieldMetadata -> fieldMetadata.getEstimationData() != null && fieldMetadata.getEstimationData().getType() == EstimationDataType.CARDINALITY).count() == numStringFields ? 1 : 0) != 0);
    }

    private Document createDummyDocument() {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        JsonNode data = mapper.valueToTree(Collections.singletonMap("TEST_NAME", "SINGLE_SAVE_TEST"));
        document.setData(data);
        return document;
    }
}

