/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.StatsRequest;
import com.flipkart.foxtrot.common.stats.StatsResponse;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatsActionTest
extends ActionTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getStatsDocuments(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test
    public void testStatsActionWithoutNesting() throws FoxtrotException, JsonProcessingException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)150L, (long)((Number)statsResponse.getResult().getStats().get("sum")).intValue());
        Assert.assertEquals((long)5L, (long)((Number)statsResponse.getResult().getStats().get("count")).intValue());
        Assert.assertNull((Object)statsResponse.getBuckets());
    }

    @Test
    public void testStatsActionWithNesting() throws FoxtrotException, JsonProcessingException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os"}));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)3L, (long)statsResponse.getBuckets().size());
        for (BucketResponse bucketResponse : statsResponse.getBuckets()) {
            Assert.assertNotNull((Object)bucketResponse.getResult());
        }
    }

    @Test
    public void testStatsActionWithMultiLevelNesting() throws FoxtrotException, JsonProcessingException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsResponse statsResponse = (StatsResponse)StatsResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsResponse);
        Assert.assertNotNull((Object)statsResponse.getResult());
        Assert.assertEquals((long)3L, (long)statsResponse.getBuckets().size());
        for (BucketResponse bucketResponse : statsResponse.getBuckets()) {
            Assert.assertNull((Object)bucketResponse.getResult());
            Assert.assertNotNull((Object)bucketResponse.getBuckets());
        }
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsActionNullTable() throws FoxtrotException, JsonProcessingException {
        StatsRequest request = new StatsRequest();
        request.setTable(null);
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        this.getQueryExecutor().execute((ActionRequest)request);
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsActionNullField() throws FoxtrotException, JsonProcessingException {
        StatsRequest request = new StatsRequest();
        request.setTable("test-table");
        request.setField(null);
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        this.getQueryExecutor().execute((ActionRequest)request);
    }
}

