/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.histogram.HistogramRequest;
import com.flipkart.foxtrot.common.histogram.HistogramResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HistogramActionTest
extends ActionTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getHistogramDocuments(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    private void filterNonZeroCounts(HistogramResponse response) {
        response.getCounts().removeIf(count -> count.getCount() == 0L);
    }

    @Test(expected=FoxtrotException.class)
    public void testHistogramActionAnyException() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.minutes);
        ((ElasticsearchConnection)Mockito.doReturn(null).when((Object)this.getElasticsearchConnection())).getClient();
        this.getQueryExecutor().execute((ActionRequest)histogramRequest);
    }

    @Test
    public void testHistogramActionIntervalMinuteNoFilter() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.minutes);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{lessThanFilter}));
        HistogramResponse response = (HistogramResponse)HistogramResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)histogramRequest));
        this.filterNonZeroCounts(response);
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>();
        counts.add(new HistogramResponse.Count((Number)1397651100000L, 2L));
        counts.add(new HistogramResponse.Count((Number)1397658060000L, 3L));
        counts.add(new HistogramResponse.Count((Number)1397658180000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397758200000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397958060000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1398653100000L, 2L));
        counts.add(new HistogramResponse.Count((Number)1398658200000L, 1L));
        Assert.assertTrue((boolean)response.getCounts().equals(counts));
    }

    @Test
    public void testHistogramActionIntervalMinuteWithFilter() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.minutes);
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{greaterThanFilter, lessThanFilter}));
        HistogramResponse response = (HistogramResponse)HistogramResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)histogramRequest));
        this.filterNonZeroCounts(response);
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>();
        counts.add(new HistogramResponse.Count((Number)1397651100000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397658060000L, 2L));
        counts.add(new HistogramResponse.Count((Number)1397658180000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397958060000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1398658200000L, 1L));
        Assert.assertTrue((boolean)response.getCounts().equals(counts));
    }

    @Test
    public void testHistogramActionIntervalHourNoFilter() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.hours);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{lessThanFilter}));
        HistogramResponse response = (HistogramResponse)HistogramResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)histogramRequest));
        this.filterNonZeroCounts(response);
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>();
        counts.add(new HistogramResponse.Count((Number)1397647800000L, 2L));
        counts.add(new HistogramResponse.Count((Number)1397655000000L, 4L));
        counts.add(new HistogramResponse.Count((Number)1397755800000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397957400000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1398652200000L, 2L));
        counts.add(new HistogramResponse.Count((Number)1398655800000L, 1L));
        Assert.assertTrue((boolean)response.getCounts().equals(counts));
    }

    @Test
    public void testHistogramActionIntervalHourWithFilter() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.hours);
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{greaterThanFilter, lessThanFilter}));
        HistogramResponse response = (HistogramResponse)HistogramResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)histogramRequest));
        this.filterNonZeroCounts(response);
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>();
        counts.add(new HistogramResponse.Count((Number)1397647800000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397655000000L, 3L));
        counts.add(new HistogramResponse.Count((Number)1397957400000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1398655800000L, 1L));
        Assert.assertTrue((boolean)response.getCounts().equals(counts));
    }

    @Test
    public void testHistogramActionIntervalDayNoFilter() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.days);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{lessThanFilter}));
        HistogramResponse response = (HistogramResponse)HistogramResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)histogramRequest));
        this.filterNonZeroCounts(response);
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>();
        counts.add(new HistogramResponse.Count((Number)1397586600000L, 6L));
        counts.add(new HistogramResponse.Count((Number)1397673000000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1397932200000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1398623400000L, 3L));
        Assert.assertTrue((boolean)response.getCounts().equals(counts));
    }

    @Test
    public void testHistogramActionIntervalDayWithFilter() throws FoxtrotException, JsonProcessingException {
        HistogramRequest histogramRequest = new HistogramRequest();
        histogramRequest.setTable("test-table");
        histogramRequest.setPeriod(Period.days);
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        histogramRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{greaterThanFilter, lessThanFilter}));
        HistogramResponse response = (HistogramResponse)HistogramResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)histogramRequest));
        this.filterNonZeroCounts(response);
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>();
        counts.add(new HistogramResponse.Count((Number)1397586600000L, 4L));
        counts.add(new HistogramResponse.Count((Number)1397932200000L, 1L));
        counts.add(new HistogramResponse.Count((Number)1398623400000L, 1L));
        Assert.assertTrue((boolean)response.getCounts().equals(counts));
    }
}

