/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.CardinalityOverflowException;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

@Ignore
public class GroupActionTest
extends ActionTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getGroupDocuments(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
        this.getTableMetadataManager().updateEstimationData("test-table", 1397658117000L);
    }

    @Ignore
    @Test
    public void testGroupActionSingleQueryException() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("os"));
        ((ElasticsearchConnection)Mockito.doReturn(null).when((Object)this.getElasticsearchConnection())).getClient();
        try {
            this.getQueryExecutor().execute((ActionRequest)groupRequest);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            ex.printStackTrace();
            Assert.assertEquals((Object)ErrorCode.ACTION_EXECUTION_ERROR, (Object)ex.getCode());
        }
    }

    @Test
    public void testGroupActionSingleFieldNoFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("os"));
        HashMap response = Maps.newHashMap();
        response.put("android", 7L);
        response.put("ios", 4L);
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }

    @Test
    public void testGroupActionSingleFieldEmptyFieldNoFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList(""));
        try {
            this.getQueryExecutor().execute((ActionRequest)groupRequest);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            ex.printStackTrace();
            Assert.assertEquals((Object)ErrorCode.MALFORMED_QUERY, (Object)ex.getCode());
        }
    }

    @Test
    public void testGroupActionSingleFieldSpecialCharactersNoFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Arrays.asList(""));
        try {
            this.getQueryExecutor().execute((ActionRequest)groupRequest);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            ex.printStackTrace();
            Assert.assertEquals((Object)ErrorCode.MALFORMED_QUERY, (Object)ex.getCode());
        }
    }

    @Test
    public void testGroupActionSingleFieldHavingSpecialCharactersWithFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("device");
        equalsFilter.setValue((Object)"nexus");
        groupRequest.setFilters(Collections.singletonList(equalsFilter));
        groupRequest.setNesting(Arrays.asList("!@#$%^&*()"));
        HashMap response = Maps.newHashMap();
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }

    @Test
    public void testGroupActionSingleFieldWithFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("device");
        equalsFilter.setValue((Object)"nexus");
        groupRequest.setFilters(Collections.singletonList(equalsFilter));
        groupRequest.setNesting(Arrays.asList("os"));
        HashMap response = Maps.newHashMap();
        response.put("android", 5L);
        response.put("ios", 1L);
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }

    @Test
    public void testGroupActionTwoFieldsNoFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Arrays.asList("os", "device"));
        HashMap response = Maps.newHashMap();
        response.put("android", new HashMap<String, Object>(){
            {
                this.put("nexus", 5L);
                this.put("galaxy", 2L);
            }
        });
        response.put("ios", new HashMap<String, Object>(){
            {
                this.put("nexus", 1L);
                this.put("ipad", 2L);
                this.put("iphone", 1L);
            }
        });
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }

    @Test
    public void testGroupActionTwoFieldsWithFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Arrays.asList("os", "device"));
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        groupRequest.setFilters(Collections.singletonList(greaterThanFilter));
        HashMap response = Maps.newHashMap();
        response.put("android", new HashMap<String, Object>(){
            {
                this.put("nexus", 3L);
                this.put("galaxy", 2L);
            }
        });
        response.put("ios", new HashMap<String, Object>(){
            {
                this.put("ipad", 1L);
            }
        });
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }

    @Test(expected=CardinalityOverflowException.class)
    public void testGroupActionMultipleFieldsNoFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Arrays.asList("os", "device", "version"));
        HashMap response = Maps.newHashMap();
        final HashMap<String, Object> nexusResponse = new HashMap<String, Object>(){
            {
                this.put("1", 2L);
                this.put("2", 2L);
                this.put("3", 1L);
            }
        };
        final HashMap<String, Object> galaxyResponse = new HashMap<String, Object>(){
            {
                this.put("2", 1L);
                this.put("3", 1L);
            }
        };
        response.put("android", new HashMap<String, Object>(){
            {
                this.put("nexus", nexusResponse);
                this.put("galaxy", galaxyResponse);
            }
        });
        final HashMap<String, Object> nexusResponse2 = new HashMap<String, Object>(){
            {
                this.put("2", 1L);
            }
        };
        final HashMap<String, Object> iPadResponse = new HashMap<String, Object>(){
            {
                this.put("2", 2L);
            }
        };
        final HashMap<String, Object> iPhoneResponse = new HashMap<String, Object>(){
            {
                this.put("1", 1L);
            }
        };
        response.put("ios", new HashMap<String, Object>(){
            {
                this.put("nexus", nexusResponse2);
                this.put("ipad", iPadResponse);
                this.put("iphone", iPhoneResponse);
            }
        });
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }

    @Test
    public void testGroupActionMultipleFieldsWithFilter() throws FoxtrotException, JsonProcessingException {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Arrays.asList("os", "device", "version"));
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        groupRequest.setFilters(Collections.singletonList(greaterThanFilter));
        HashMap response = Maps.newHashMap();
        final HashMap<String, Object> nexusResponse = new HashMap<String, Object>(){
            {
                this.put("2", 2L);
                this.put("3", 1L);
            }
        };
        final HashMap<String, Object> galaxyResponse = new HashMap<String, Object>(){
            {
                this.put("2", 1L);
                this.put("3", 1L);
            }
        };
        response.put("android", new HashMap<String, Object>(){
            {
                this.put("nexus", nexusResponse);
                this.put("galaxy", galaxyResponse);
            }
        });
        final HashMap<String, Object> iPadResponse = new HashMap<String, Object>(){
            {
                this.put("2", 1L);
            }
        };
        response.put("ios", new HashMap<String, Object>(){
            {
                this.put("ipad", iPadResponse);
            }
        });
        GroupResponse actualResult = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertEquals((Object)response, (Object)actualResult.getResult());
    }
}

