/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.CardinalityOverflowException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class GroupActionEstimationTest
extends ActionTest {
    private static final Logger log = LoggerFactory.getLogger(GroupActionEstimationTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getGroupDocumentsForEstimation(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
        this.getTableMetadataManager().updateEstimationData("test-table", 1397658117000L);
    }

    @Test
    public void testEstimationNoFilter() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("os"));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertTrue((boolean)response.getResult().containsKey("android"));
        Assert.assertTrue((boolean)response.getResult().containsKey("ios"));
    }

    @Test(expected=CardinalityOverflowException.class)
    public void testEstimationNoFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        this.getQueryExecutor().execute((ActionRequest)groupRequest);
    }

    @Test
    public void testEstimationTemporalFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)BetweenFilter.builder().field("_timestamp").temporal(true).from((Number)1397658117000L).to((Number)1397658237000L).build()));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        Assert.assertFalse((boolean)response.getResult().isEmpty());
    }

    @Test
    public void testEstimationCardinalFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)EqualsFilter.builder().field("os").value((Object)"ios").build()));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        Assert.assertFalse((boolean)response.getResult().isEmpty());
    }

    @Test(expected=CardinalityOverflowException.class)
    public void testEstimationGTFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)GreaterThanFilter.builder().field("value").value((Number)10).build()));
        this.getQueryExecutor().execute((ActionRequest)groupRequest);
    }

    @Test
    public void testEstimationLTFilterHighCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)LessThanFilter.builder().field("value").value((Number)30).build()));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        Assert.assertFalse((boolean)response.getResult().isEmpty());
    }

    @Test(expected=CardinalityOverflowException.class)
    public void testEstimationLTFilterHighCardinalityBlocked() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("deviceId"));
        groupRequest.setFilters((List)ImmutableList.of((Object)LessThanFilter.builder().field("value").value((Number)80).build()));
        log.debug(this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)groupRequest));
        this.getQueryExecutor().execute((ActionRequest)groupRequest);
    }
}

