/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.Query;
import com.flipkart.foxtrot.common.query.QueryResponse;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.query.general.AnyFilter;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.general.NotEqualsFilter;
import com.flipkart.foxtrot.common.query.general.NotInFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.query.string.ContainsFilter;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class FilterActionTest
extends ActionTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getQueryDocuments(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test(expected=FoxtrotException.class)
    public void testQueryException() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.asc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        Mockito.when((Object)this.getElasticsearchConnection().getClient()).thenReturn(null);
        this.getQueryExecutor().execute((ActionRequest)query);
    }

    @Test
    public void testQueryNoFilterAscending() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.asc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryNoFilterDescending() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryNoFilterWithLimit() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(2);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryTotalHitsWithLimit() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(2);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
        Assert.assertEquals((long)9L, (long)actualResponse.getTotalHits());
    }

    @Test
    public void testQueryAnyFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        AnyFilter filter = new AnyFilter();
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{filter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryEqualsFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"ios");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryNotEqualsFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(3);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        NotEqualsFilter notEqualsFilter = new NotEqualsFilter();
        notEqualsFilter.setField("os");
        notEqualsFilter.setValue((Object)"ios");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{notEqualsFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryNotInFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(100);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        NotInFilter notInFilter = new NotInFilter();
        notInFilter.setValues((List)Lists.newArrayList((Object[])new Object[]{"nexus", "galaxy"}));
        notInFilter.setField("device");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{notInFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryNotInFilterMissingField() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(100);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        NotInFilter notInFilter = new NotInFilter();
        notInFilter.setValues((List)Lists.newArrayList((Object[])new Object[]{"nexus", "galaxy", "ipad", "iphone"}));
        notInFilter.setField("dummy");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{notInFilter}));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        Assert.assertEquals((long)9L, (long)actualResponse.getDocuments().size());
    }

    @Test
    public void testQueryGreaterThanFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(3);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
        greaterThanFilter.setField("battery");
        greaterThanFilter.setValue((Number)48);
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{greaterThanFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryGreaterEqualFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(3);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        GreaterEqualFilter greaterEqualFilter = new GreaterEqualFilter();
        greaterEqualFilter.setField("battery");
        greaterEqualFilter.setValue((Number)48);
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{greaterEqualFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryLessThanFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(3);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setField("battery");
        lessThanFilter.setValue((Number)48);
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{lessThanFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryLessEqualFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(3);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        LessEqualFilter lessEqualFilter = new LessEqualFilter();
        lessEqualFilter.setField("battery");
        lessEqualFilter.setValue((Number)48);
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{lessEqualFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryBetweenFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        query.setLimit(3);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setField("battery");
        betweenFilter.setFrom((Number)47);
        betweenFilter.setTo((Number)75);
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{betweenFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryContainsFilter() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ContainsFilter containsFilter = new ContainsFilter();
        containsFilter.setField("os");
        containsFilter.setValue("*droid*");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{containsFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryEmptyResult() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"wp8");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter}));
        ArrayList<Document> documents = new ArrayList<Document>();
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryMultipleFiltersEmptyResult() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"android");
        GreaterEqualFilter greaterEqualFilter = new GreaterEqualFilter();
        greaterEqualFilter.setField("battery");
        greaterEqualFilter.setValue((Number)100);
        Vector<Object> filters = new Vector<Object>();
        filters.add(equalsFilter);
        filters.add(greaterEqualFilter);
        query.setFilters(filters);
        ArrayList<Document> documents = new ArrayList<Document>();
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryMultipleFiltersAndCombiner() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"android");
        GreaterEqualFilter greaterEqualFilter = new GreaterEqualFilter();
        greaterEqualFilter.setField("battery");
        greaterEqualFilter.setValue((Number)98);
        Vector<Object> filters = new Vector<Object>();
        filters.add(equalsFilter);
        filters.add(greaterEqualFilter);
        query.setFilters(filters);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Ignore
    @Test
    public void testQueryMultipleFiltersOrCombiner() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"ios");
        EqualsFilter equalsFilter2 = new EqualsFilter();
        equalsFilter2.setField("device");
        equalsFilter2.setValue((Object)"nexus");
        Vector<EqualsFilter> filters = new Vector<EqualsFilter>();
        filters.add(equalsFilter);
        filters.add(equalsFilter2);
        query.setFilters(filters);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
    }

    @Test
    public void testQueryPagination() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"ios");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter}));
        query.setFrom(1);
        query.setLimit(1);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryNullFilters() throws FoxtrotException, JsonProcessingException, InterruptedException {
        Query query = new Query();
        query.setTable("test-table");
        query.setFilters(null);
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Ignore
    @Test
    public void testQueryNullCombiner() throws FoxtrotException, JsonProcessingException, InterruptedException {
        Query query = new Query();
        query.setTable("test-table");
        query.setFilters(new ArrayList());
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, this.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, this.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, this.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, this.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, this.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, this.getMapper()));
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testQueryCaching() throws FoxtrotException, JsonProcessingException {
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.desc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("os");
        equalsFilter.setValue((Object)"ios");
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter}));
        query.setFrom(1);
        query.setLimit(1);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, this.getMapper()));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        this.compare(documents, actualResponse.getDocuments());
    }

    @Test
    public void testMissingIndicesQuery() throws FoxtrotException {
        List<Document> documents = TestUtils.getQueryDocumentsDifferentDate(this.getMapper(), new Date(114, 4, 1).getTime());
        documents.addAll(TestUtils.getQueryDocumentsDifferentDate(this.getMapper(), new Date(114, 4, 5).getTime()));
        this.getQueryStore().save("test-table", documents);
        for (Document document : documents) {
            this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{ElasticsearchUtils.getCurrentIndex((String)"test-table", (long)document.getTimestamp())}).execute().actionGet();
        }
        GetIndexResponse response = (GetIndexResponse)this.getElasticsearchServer().getClient().admin().indices().getIndex(new GetIndexRequest()).actionGet();
        Assert.assertEquals((long)3L, (long)Arrays.stream(response.getIndices()).filter(index -> !index.equals("table-meta")).count());
        Query query = new Query();
        query.setLimit(documents.size());
        query.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setField("_timestamp");
        betweenFilter.setFrom((Number)documents.get(0).getTimestamp());
        betweenFilter.setTo((Number)documents.get(documents.size() - 1).getTimestamp());
        betweenFilter.setTemporal(true);
        query.setFilters((List)Lists.newArrayList((Object[])new Filter[]{betweenFilter}));
        QueryResponse actualResponse = (QueryResponse)QueryResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)query));
        Assert.assertEquals((long)documents.size(), (long)actualResponse.getDocuments().size());
    }

    public void compare(List<Document> expectedDocuments, List<Document> actualDocuments) {
        Assert.assertEquals((long)expectedDocuments.size(), (long)actualDocuments.size());
        for (int i = 0; i < expectedDocuments.size(); ++i) {
            Document expected = expectedDocuments.get(i);
            Document actual = actualDocuments.get(i);
            Assert.assertNotNull((Object)expected);
            Assert.assertNotNull((Object)actual);
            Assert.assertNotNull((String)"Actual document Id should not be null", (Object)actual.getId());
            Assert.assertNotNull((String)"Actual document data should not be null", (Object)actual.getData());
            Assert.assertEquals((String)"Actual Doc Id should match expected Doc Id", (Object)expected.getId(), (Object)actual.getId());
            Assert.assertEquals((String)"Actual Doc Timestamp should match expected Doc Timestamp", (long)expected.getTimestamp(), (long)actual.getTimestamp());
            Map expectedMap = (Map)this.getMapper().convertValue((Object)expected.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            Map actualMap = (Map)this.getMapper().convertValue((Object)actual.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            Assert.assertEquals((String)"Actual data should match expected data", (Object)expectedMap, (Object)actualMap);
        }
    }
}

