/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.core.MockElasticsearchServer;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.cache.impl.DistributedCacheFactory;
import com.flipkart.foxtrot.core.common.NonCacheableAction;
import com.flipkart.foxtrot.core.common.NonCacheableActionRequest;
import com.flipkart.foxtrot.core.common.RequestWithNoAction;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.QueryExecutor;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.impl.CacheConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.elasticsearch.client.Client;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class QueryExecutorTest {
    private QueryExecutor queryExecutor;
    private ObjectMapper mapper = new ObjectMapper();
    private MockElasticsearchServer elasticsearchServer;
    private HazelcastInstance hazelcastInstance;
    private AnalyticsLoader analyticsLoader;

    @Before
    public void setUp() throws Exception {
        DataStore dataStore = TestUtils.getDataStore();
        this.hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)this.hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)new Config());
        CacheManager cacheManager = new CacheManager((CacheFactory)new DistributedCacheFactory(hazelcastConnection, this.mapper, new CacheConfig()));
        this.elasticsearchServer = new MockElasticsearchServer(UUID.randomUUID().toString());
        ElasticsearchConnection elasticsearchConnection = (ElasticsearchConnection)Mockito.mock(ElasticsearchConnection.class);
        Mockito.when((Object)elasticsearchConnection.getClient()).thenReturn((Object)this.elasticsearchServer.getClient());
        ElasticsearchUtils.initializeMappings((Client)this.elasticsearchServer.getClient());
        TableMetadataManager tableMetadataManager = (TableMetadataManager)Mockito.mock(TableMetadataManager.class);
        Mockito.when((Object)tableMetadataManager.exists(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)tableMetadataManager.get(Mockito.anyString())).thenReturn((Object)TestUtils.TEST_TABLE);
        QueryStore queryStore = (QueryStore)Mockito.mock(QueryStore.class);
        this.analyticsLoader = (AnalyticsLoader)Mockito.spy((Object)new AnalyticsLoader(tableMetadataManager, dataStore, queryStore, elasticsearchConnection, cacheManager, this.mapper));
        TestUtils.registerActions(this.analyticsLoader, this.mapper);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        this.queryExecutor = new QueryExecutor(this.analyticsLoader, executorService);
    }

    @After
    public void tearDown() throws Exception {
        this.elasticsearchServer.shutdown();
        this.hazelcastInstance.shutdown();
    }

    @Test
    public void testResolve() throws Exception {
        Assert.assertEquals(NonCacheableAction.class, this.queryExecutor.resolve((ActionRequest)new NonCacheableActionRequest()).getClass());
    }

    @Test
    public void testResolveNonExistentAction() throws Exception {
        try {
            this.queryExecutor.resolve((ActionRequest)new RequestWithNoAction());
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.UNRESOLVABLE_OPERATION, (Object)e.getCode());
        }
    }

    @Test
    public void testResolveLoaderException() throws Exception {
        try {
            ((AnalyticsLoader)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.analyticsLoader)).getAction((ActionRequest)Mockito.any(ActionRequest.class));
            this.queryExecutor.resolve((ActionRequest)new NonCacheableActionRequest());
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.ACTION_RESOLUTION_FAILURE, (Object)e.getCode());
        }
    }
}

