/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.FieldMetadata;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.common.estimation.CardinalityEstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationDataVisitor;
import com.flipkart.foxtrot.common.estimation.FixedEstimationData;
import com.flipkart.foxtrot.common.estimation.PercentileEstimationData;
import com.flipkart.foxtrot.common.estimation.TermHistogramEstimationData;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.parsers.ElasticsearchMappingParser;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.TableMapStore;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.IMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTableMetadataManager
implements TableMetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(DistributedTableMetadataManager.class);
    private static final String DATA_MAP = "tablemetadatamap";
    private static final String FIELD_MAP = "tablefieldmap";
    private static final String CARDINALITY_FIELD_MAP = "cardinalitytablefieldmap";
    private static final int PRECISION_THRESHOLD = 100;
    private static final int TIME_TO_LIVE_CACHE = (int)TimeUnit.MINUTES.toSeconds(15L);
    private static final int TIME_TO_LIVE_TABLE_CACHE = (int)TimeUnit.DAYS.toSeconds(30L);
    private static final int TIME_TO_LIVE_CARDINALITY_CACHE = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final int TIME_TO_NEAR_CACHE = (int)TimeUnit.MINUTES.toSeconds(15L);
    private final HazelcastConnection hazelcastConnection;
    private final ElasticsearchConnection elasticsearchConnection;
    private final ObjectMapper mapper;
    private IMap<String, Table> tableDataStore;
    private IMap<String, TableFieldMapping> fieldDataCache;
    private IMap<String, TableFieldMapping> fieldDataCardinalityCache;
    private final CardinalityConfig cardinalityConfig;

    public DistributedTableMetadataManager(HazelcastConnection hazelcastConnection, ElasticsearchConnection elasticsearchConnection, ObjectMapper mapper, CardinalityConfig cardinalityConfig) {
        this.hazelcastConnection = hazelcastConnection;
        this.elasticsearchConnection = elasticsearchConnection;
        this.mapper = mapper;
        this.cardinalityConfig = cardinalityConfig;
        hazelcastConnection.getHazelcastConfig().getMapConfigs().put(DATA_MAP, this.tableMapConfig());
        hazelcastConnection.getHazelcastConfig().getMapConfigs().put(FIELD_MAP, this.fieldMetaMapConfig());
        hazelcastConnection.getHazelcastConfig().getMapConfigs().put(CARDINALITY_FIELD_MAP, this.cardinalityFieldMetaMapConfig());
    }

    private MapConfig tableMapConfig() {
        MapConfig mapConfig = new MapConfig();
        mapConfig.setReadBackupData(true);
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setTimeToLiveSeconds(TIME_TO_LIVE_TABLE_CACHE);
        mapConfig.setBackupCount(0);
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setFactoryImplementation((Object)TableMapStore.factory(this.elasticsearchConnection));
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setInitialLoadMode(MapStoreConfig.InitialLoadMode.EAGER);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setTimeToLiveSeconds(TIME_TO_LIVE_TABLE_CACHE);
        nearCacheConfig.setInvalidateOnChange(true);
        mapConfig.setNearCacheConfig(nearCacheConfig);
        return mapConfig;
    }

    private MapConfig fieldMetaMapConfig() {
        MapConfig mapConfig = new MapConfig();
        mapConfig.setReadBackupData(true);
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setTimeToLiveSeconds(TIME_TO_LIVE_CACHE);
        mapConfig.setBackupCount(0);
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setTimeToLiveSeconds(TIME_TO_NEAR_CACHE);
        nearCacheConfig.setInvalidateOnChange(true);
        mapConfig.setNearCacheConfig(nearCacheConfig);
        return mapConfig;
    }

    private MapConfig cardinalityFieldMetaMapConfig() {
        MapConfig mapConfig = new MapConfig();
        mapConfig.setReadBackupData(true);
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setTimeToLiveSeconds(TIME_TO_LIVE_CARDINALITY_CACHE);
        mapConfig.setBackupCount(0);
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setTimeToLiveSeconds(TIME_TO_LIVE_CARDINALITY_CACHE);
        nearCacheConfig.setInvalidateOnChange(true);
        mapConfig.setNearCacheConfig(nearCacheConfig);
        return mapConfig;
    }

    @Override
    public void save(Table table) throws FoxtrotException {
        logger.info(String.format("Saving Table : %s", table));
        this.tableDataStore.put((Object)table.getName(), (Object)table);
        this.tableDataStore.flush();
    }

    @Override
    public Table get(String tableName) throws FoxtrotException {
        logger.debug(String.format("Getting Table : %s", tableName));
        if (this.tableDataStore.containsKey((Object)tableName)) {
            return (Table)this.tableDataStore.get((Object)tableName);
        }
        return null;
    }

    @Override
    public List<Table> get() throws FoxtrotException {
        if (0 == this.tableDataStore.size()) {
            return Collections.emptyList();
        }
        ArrayList tables = Lists.newArrayList((Iterable)this.tableDataStore.values());
        tables.sort(Comparator.comparing(table -> table.getName().toLowerCase()));
        return tables;
    }

    @Override
    @Timed
    public TableFieldMapping getFieldMappings(String tableName, boolean withCardinality, boolean calculateCardinality) throws FoxtrotException {
        TableFieldMapping tableFieldMapping;
        String table = ElasticsearchUtils.getValidTableName(tableName);
        if (!this.tableDataStore.containsKey((Object)table)) {
            throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
        }
        if (this.fieldDataCache.containsKey((Object)table) && !withCardinality) {
            tableFieldMapping = (TableFieldMapping)this.fieldDataCache.get((Object)table);
        } else if (this.fieldDataCardinalityCache.containsKey((Object)table) && withCardinality && !calculateCardinality) {
            tableFieldMapping = (TableFieldMapping)this.fieldDataCardinalityCache.get((Object)table);
        } else {
            ElasticsearchMappingParser mappingParser = new ElasticsearchMappingParser(this.mapper);
            String indices = ElasticsearchUtils.getIndices(table);
            logger.info("Selected indices: {}", (Object)indices);
            GetMappingsResponse mappingsResponse = (GetMappingsResponse)this.elasticsearchConnection.getClient().admin().indices().prepareGetMappings(new String[]{indices}).execute().actionGet();
            HashSet indicesName = Sets.newHashSet();
            for (ObjectCursor index2 : mappingsResponse.getMappings().keys()) {
                indicesName.add(index2.value);
            }
            List fieldMetadata = indicesName.stream().filter(x -> !CollectionUtils.isNullOrEmpty((String)x)).sorted((lhs, rhs) -> {
                Date lhsDate = ElasticsearchUtils.parseIndexDate(lhs, table).toDate();
                Date rhsDate = ElasticsearchUtils.parseIndexDate(rhs, table).toDate();
                return 0 - lhsDate.compareTo(rhsDate);
            }).map(index -> (MappingMetaData)((ImmutableOpenMap)mappingsResponse.mappings().get(index)).get((Object)"document")).flatMap(mappingData -> {
                try {
                    return mappingParser.getFieldMappings((MappingMetaData)mappingData).stream();
                }
                catch (IOException e) {
                    logger.error("Could not read mapping from " + mappingData, (Throwable)e);
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
            TreeSet<FieldMetadata> fieldMetadataTreeSet = new TreeSet<FieldMetadata>(new FieldMetadataComparator());
            fieldMetadataTreeSet.addAll(fieldMetadata);
            tableFieldMapping = new TableFieldMapping(table, fieldMetadataTreeSet);
            if (calculateCardinality) {
                this.estimateCardinality(table, tableFieldMapping.getMappings(), DateTime.now().minusDays(1).toDate().getTime());
                this.fieldDataCardinalityCache.put((Object)table, (Object)tableFieldMapping);
            } else {
                this.fieldDataCache.put((Object)table, (Object)tableFieldMapping);
            }
        }
        return TableFieldMapping.builder().table(table).mappings(tableFieldMapping.getMappings().stream().map(x -> FieldMetadata.builder().field(x.getField()).type(x.getType()).estimationData(withCardinality ? x.getEstimationData() : null).build()).collect(Collectors.toSet())).build();
    }

    @Override
    public void updateEstimationData(String table, long timestamp) throws FoxtrotException {
        if (!this.tableDataStore.containsKey((Object)table)) {
            throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
        }
        TableFieldMapping tableFieldMapping = this.getFieldMappings(table, this.cardinalityConfig.isEnabled(), false);
        this.fieldDataCache.put((Object)table, (Object)tableFieldMapping);
    }

    private void estimateCardinality(String table, Collection<FieldMetadata> fields, long time) throws FoxtrotException {
        if (CollectionUtils.isNullOrEmpty(fields)) {
            logger.warn("No fields.. Nothing to query");
            return;
        }
        Map<String, FieldMetadata> fieldMap = fields.stream().collect(Collectors.toMap(FieldMetadata::getField, fieldMetadata -> fieldMetadata, (lhs, rhs) -> lhs));
        String index = ElasticsearchUtils.getCurrentIndex(ElasticsearchUtils.getValidTableName(table), time);
        Client client = this.elasticsearchConnection.getClient();
        Map<String, EstimationData> estimationData = this.estimateFirstPhaseData(table, index, client, fieldMap);
        estimationData = this.estimateSecondPhaseData(table, index, client, estimationData);
        estimationData.forEach((key, value) -> ((FieldMetadata)fieldMap.get(key)).setEstimationData(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, EstimationData> estimateFirstPhaseData(String table, String index, Client client, Map<String, FieldMetadata> fields) {
        MultiSearchRequestBuilder multiQuery = client.prepareMultiSearch();
        HashMap estimationDataMap = Maps.newHashMap();
        int subListSize = this.cardinalityConfig == null || this.cardinalityConfig.getSubListSize() == 0 ? 50 : this.cardinalityConfig.getSubListSize();
        List listofMaps = fields.entrySet().stream().collect(DistributedTableMetadataManager.mapSize(subListSize));
        for (Map innerMap : listofMaps) {
            MultiSearchResponse multiResponse;
            innerMap.values().forEach(fieldMetadata -> {
                String field = fieldMetadata.getField();
                SearchRequestBuilder query = client.prepareSearch(new String[]{index}).setIndicesOptions(Utils.indicesOptions()).setQuery((QueryBuilder)QueryBuilders.existsQuery((String)field)).setSize(0);
                switch (fieldMetadata.getType()) {
                    case STRING: {
                        logger.info("table:{} field:{} type:{} aggregationType:{}", new Object[]{table, field, fieldMetadata.getType(), "cardinality"});
                        query.addAggregation((AbstractAggregationBuilder)((CardinalityBuilder)AggregationBuilders.cardinality((String)field).field(field)).precisionThreshold(100L));
                        break;
                    }
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        logger.info("table:{} field:{} type:{} aggregationType:{}", new Object[]{table, field, fieldMetadata.getType(), "percentile"});
                        query.addAggregation((AbstractAggregationBuilder)((PercentilesBuilder)AggregationBuilders.percentiles((String)field).field(field)).percentiles(new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0}));
                        query.addAggregation((AbstractAggregationBuilder)((CardinalityBuilder)AggregationBuilders.cardinality((String)("_" + field)).field(field)).precisionThreshold(100L));
                        break;
                    }
                }
                multiQuery.add(query);
            });
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                multiResponse = (MultiSearchResponse)multiQuery.execute().actionGet();
            }
            catch (Throwable throwable) {
                logger.info("Cardinality query on table {} for {} fields took {} ms", new Object[]{table, fields.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                throw throwable;
            }
            logger.info("Cardinality query on table {} for {} fields took {} ms", new Object[]{table, fields.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            for (MultiSearchResponse.Item item : multiResponse.getResponses()) {
                if (item.isFailure()) {
                    logger.info("FailureInDeducingCardinality table:{} failureMessage:{}", (Object)table, (Object)item.getFailureMessage());
                    continue;
                }
                SearchResponse response = item.getResponse();
                long hits = response.getHits().totalHits();
                Aggregations aggregations = response.getAggregations();
                if (null == aggregations) continue;
                Map output = aggregations.asMap();
                output.forEach((key, value) -> {
                    FieldMetadata fieldMetadata = (FieldMetadata)fields.get(key);
                    if (fieldMetadata == null) {
                        fieldMetadata = (FieldMetadata)fields.get(key.replace("_", ""));
                    }
                    if (fieldMetadata == null) {
                        return;
                    }
                    switch (fieldMetadata.getType()) {
                        case STRING: {
                            Cardinality cardinality = (Cardinality)value;
                            logger.info("table:{} field:{} type:{} aggregationType:{} value:{}", new Object[]{table, key, fieldMetadata.getType(), "cardinality", cardinality.getValue()});
                            estimationDataMap.put(key, CardinalityEstimationData.builder().cardinality(cardinality.getValue()).count(hits).build());
                            break;
                        }
                        case INTEGER: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            if (value instanceof Percentiles) {
                                Percentiles percentiles = (Percentiles)value;
                                double[] values = new double[10];
                                for (int i = 10; i <= 100; i += 10) {
                                    values[i / 10 - 1] = percentiles.percentile((double)i);
                                }
                                logger.info("table:{} field:{} type:{} aggregationType:{} value:{}", new Object[]{table, key, fieldMetadata.getType(), "percentile", values});
                                estimationDataMap.put(key, PercentileEstimationData.builder().values(values).count(hits).build());
                                break;
                            }
                            if (!(value instanceof Cardinality)) break;
                            Cardinality cardinality = (Cardinality)value;
                            logger.info("table:{} field:{} type:{} aggregationType:{} value:{}", new Object[]{table, key, fieldMetadata.getType(), "cardinality", cardinality.getValue()});
                            EstimationData estimationData = (EstimationData)estimationDataMap.get(key.replace("_", ""));
                            if (estimationData != null && estimationData instanceof PercentileEstimationData) {
                                ((PercentileEstimationData)estimationData).setCardinality(cardinality.getValue());
                                break;
                            }
                            estimationDataMap.put(key.replace("_", ""), PercentileEstimationData.builder().cardinality(cardinality.getValue()).build());
                            break;
                        }
                        case BOOLEAN: {
                            estimationDataMap.put(key, FixedEstimationData.builder().count(2L).build());
                        }
                    }
                });
            }
        }
        return estimationDataMap;
    }

    private Map<String, EstimationData> estimateSecondPhaseData(String table, final String index, final Client client, Map<String, EstimationData> estimationData) {
        final long maxDocuments = estimationData.values().stream().map(EstimationData::getCount).max(Comparator.naturalOrder()).orElse(0L);
        if (maxDocuments == 0L) {
            return estimationData;
        }
        final MultiSearchRequestBuilder multiQuery = client.prepareMultiSearch();
        estimationData.forEach((key, value) -> value.accept((EstimationDataVisitor)new EstimationDataVisitor<Void>(){

            public Void visit(FixedEstimationData fixedEstimationData) {
                return null;
            }

            public Void visit(PercentileEstimationData percentileEstimationData) {
                return null;
            }

            public Void visit(CardinalityEstimationData cardinalityEstimationData) {
                if (cardinalityEstimationData.getCount() > 0L && cardinalityEstimationData.getCardinality() > 0L) {
                    int countToCardinalityRatio = (int)(cardinalityEstimationData.getCount() / cardinalityEstimationData.getCardinality());
                    int documentToCountRatio = (int)(maxDocuments / cardinalityEstimationData.getCount());
                    if (cardinalityEstimationData.getCardinality() <= 100L || countToCardinalityRatio > 100 && documentToCountRatio < 100 && cardinalityEstimationData.getCardinality() <= 5000L) {
                        logger.info("field:{} maxCount:{} countToCardinalityRatio:{} documentToCountRatio:{}", new Object[]{key, maxDocuments, countToCardinalityRatio, documentToCountRatio});
                        SearchRequestBuilder query = client.prepareSearch(new String[]{index}).setIndicesOptions(Utils.indicesOptions()).setQuery((QueryBuilder)QueryBuilders.existsQuery((String)key)).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)key).field(key)).size(0)).setSize(0);
                        multiQuery.add(query);
                    }
                }
                return null;
            }

            public Void visit(TermHistogramEstimationData termHistogramEstimationData) {
                return null;
            }
        }));
        HashMap estimationDataMap = Maps.newHashMap(estimationData);
        MultiSearchResponse multiResponse = (MultiSearchResponse)multiQuery.execute().actionGet();
        for (MultiSearchResponse.Item item : multiResponse.getResponses()) {
            if (item.isFailure()) {
                logger.info("FailureInDeducingCardinality table:{} failureMessage:{}", (Object)table, (Object)item.getFailureMessage());
                continue;
            }
            SearchResponse response = item.getResponse();
            long hits = response.getHits().totalHits();
            Aggregations aggregations = response.getAggregations();
            if (null == aggregations) continue;
            Map output = aggregations.asMap();
            output.forEach((key, value) -> {
                Terms terms = (Terms)output.get(key);
                estimationDataMap.put(key, TermHistogramEstimationData.builder().count(hits).termCounts(terms.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount))).build());
            });
        }
        return estimationDataMap;
    }

    @Override
    public boolean exists(String tableName) throws FoxtrotException {
        return this.tableDataStore.containsKey((Object)tableName);
    }

    @Override
    public void delete(String tableName) throws FoxtrotException {
        logger.info(String.format("Deleting Table : %s", tableName));
        if (this.tableDataStore.containsKey((Object)tableName)) {
            this.tableDataStore.delete((Object)tableName);
        }
        logger.info(String.format("Deleted Table : %s", tableName));
    }

    public void start() throws Exception {
        this.tableDataStore = this.hazelcastConnection.getHazelcast().getMap(DATA_MAP);
        this.fieldDataCache = this.hazelcastConnection.getHazelcast().getMap(FIELD_MAP);
        this.fieldDataCardinalityCache = this.hazelcastConnection.getHazelcast().getMap(CARDINALITY_FIELD_MAP);
    }

    public void stop() throws Exception {
    }

    private static <K, V> Collector<Map.Entry<K, V>, ?, List<Map<K, V>>> mapSize(int limit) {
        return Collector.of(ArrayList::new, (l, e) -> {
            if (l.isEmpty() || ((Map)l.get(l.size() - 1)).size() == limit) {
                l.add(new HashMap());
            }
            ((Map)l.get(l.size() - 1)).put(e.getKey(), e.getValue());
        }, (l1, l2) -> {
            if (l1.isEmpty()) {
                return l2;
            }
            if (l2.isEmpty()) {
                return l1;
            }
            if (((Map)l1.get(l1.size() - 1)).size() < limit) {
                Map map = (Map)l1.get(l1.size() - 1);
                ListIterator mapsIte = l2.listIterator(l2.size());
                while (mapsIte.hasPrevious() && map.size() < limit) {
                    Iterator ite = ((Map)mapsIte.previous()).entrySet().iterator();
                    while (ite.hasNext() && map.size() < limit) {
                        Map.Entry entry = ite.next();
                        map.put(entry.getKey(), entry.getValue());
                        ite.remove();
                    }
                    if (ite.hasNext()) continue;
                    mapsIte.remove();
                }
            }
            l1.addAll(l2);
            return l1;
        }, new Collector.Characteristics[0]);
    }

    private static class FieldMetadataComparator
    implements Comparator<FieldMetadata>,
    Serializable {
        private static final long serialVersionUID = 8557746595191991528L;

        private FieldMetadataComparator() {
        }

        @Override
        public int compare(FieldMetadata o1, FieldMetadata o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getField().compareTo(o2.getField());
        }
    }
}

