/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.util.MetricUtil;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchQueryStore
implements QueryStore {
    private static final Logger logger = LoggerFactory.getLogger((String)ElasticsearchQueryStore.class.getSimpleName());
    private static final String TABLE_META = "tableMeta";
    private static final String DATA_STORE = "dataStore";
    private static final String QUERY_STORE = "queryStore";
    private final ElasticsearchConnection connection;
    private final DataStore dataStore;
    private final TableMetadataManager tableMetadataManager;
    private final ObjectMapper mapper;
    private final CardinalityConfig cardinalityConfig;

    public ElasticsearchQueryStore(TableMetadataManager tableMetadataManager, ElasticsearchConnection connection, DataStore dataStore, ObjectMapper mapper, CardinalityConfig cardinalityConfig) {
        this.connection = connection;
        this.dataStore = dataStore;
        this.tableMetadataManager = tableMetadataManager;
        this.mapper = mapper;
        this.cardinalityConfig = cardinalityConfig;
    }

    @Override
    @Timed
    public void initializeTable(String table) throws FoxtrotException {
    }

    @Override
    @Timed
    public void save(String table, Document document) throws FoxtrotException {
        table = ElasticsearchUtils.getValidTableName(table);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String action = "";
        try {
            if (!this.tableMetadataManager.exists(table)) {
                throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
            }
            if (new DateTime().plusDays(1).minus(document.getTimestamp()).getMillis() < 0L) {
                return;
            }
            action = TABLE_META;
            stopwatch.reset().start();
            Table tableMeta = this.tableMetadataManager.get(table);
            logger.info("TableMetaGetTook:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            MetricUtil.getInstance().registerActionSuccess(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            action = DATA_STORE;
            Document translatedDocument = this.dataStore.save(tableMeta, document);
            logger.info("DataStoreTook:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            MetricUtil.getInstance().registerActionSuccess(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            action = QUERY_STORE;
            long timestamp = translatedDocument.getTimestamp();
            ((IndexRequestBuilder)((IndexRequestBuilder)this.connection.getClient().prepareIndex().setIndex(ElasticsearchUtils.getCurrentIndex(table, timestamp))).setType("document").setId(translatedDocument.getId()).setTimestamp(Long.toString(timestamp)).setSource(this.convert(translatedDocument)).setConsistencyLevel(WriteConsistencyLevel.QUORUM)).execute().get(2L, TimeUnit.SECONDS);
            logger.info("QueryStoreTook:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            MetricUtil.getInstance().registerActionSuccess(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            MetricUtil.getInstance().registerActionFailure(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw FoxtrotExceptions.createExecutionException(table, e);
        }
    }

    @Override
    @Timed
    public void save(String table, List<Document> documents) throws FoxtrotException {
        table = ElasticsearchUtils.getValidTableName(table);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String action = "";
        try {
            if (!this.tableMetadataManager.exists(table)) {
                throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
            }
            if (documents == null || documents.size() == 0) {
                throw FoxtrotExceptions.createBadRequestException(table, "Empty Document List Not Allowed");
            }
            action = TABLE_META;
            stopwatch.reset().start();
            Table tableMeta = this.tableMetadataManager.get(table);
            logger.info("TableMetaGetTook:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            MetricUtil.getInstance().registerActionSuccess(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            action = DATA_STORE;
            List<Document> translatedDocuments = this.dataStore.saveAll(tableMeta, documents);
            logger.info("DataStoreTook:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            MetricUtil.getInstance().registerActionSuccess(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            action = QUERY_STORE;
            BulkRequestBuilder bulkRequestBuilder = this.connection.getClient().prepareBulk();
            DateTime dateTime = new DateTime().plusDays(1);
            for (Document document : translatedDocuments) {
                long timestamp = document.getTimestamp();
                if (dateTime.minus(timestamp).getMillis() < 0L) continue;
                String index = ElasticsearchUtils.getCurrentIndex(table, timestamp);
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(index)).type("document").id(document.getId()).timestamp(Long.toString(timestamp)).source(this.convert(document));
                bulkRequestBuilder.add(indexRequest);
            }
            if (bulkRequestBuilder.numberOfActions() > 0) {
                BulkResponse responses = (BulkResponse)bulkRequestBuilder.setConsistencyLevel(WriteConsistencyLevel.QUORUM).execute().get(10L, TimeUnit.SECONDS);
                logger.info("QueryStoreTook:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                MetricUtil.getInstance().registerActionSuccess(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
                for (int i = 0; i < responses.getItems().length; ++i) {
                    BulkItemResponse itemResponse = responses.getItems()[i];
                    if (!itemResponse.isFailed()) continue;
                    logger.error(String.format("Table : %s Failure Message : %s Document : %s", table, itemResponse.getFailureMessage(), this.mapper.writeValueAsString((Object)documents.get(i))));
                }
            }
        }
        catch (JsonProcessingException e) {
            MetricUtil.getInstance().registerActionFailure(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw FoxtrotExceptions.createBadRequestException(table, (Exception)((Object)e));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            MetricUtil.getInstance().registerActionFailure(action, table, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw FoxtrotExceptions.createExecutionException(table, e);
        }
    }

    @Override
    @Timed
    public Document get(String table, String id) throws FoxtrotException {
        String lookupKey;
        if (!this.tableMetadataManager.exists(table = ElasticsearchUtils.getValidTableName(table))) {
            throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
        }
        Table fxTable = this.tableMetadataManager.get(table);
        SearchResponse searchResponse = (SearchResponse)this.connection.getClient().prepareSearch(new String[]{ElasticsearchUtils.getIndices(table)}).setTypes(new String[]{"document"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)ElasticsearchUtils.DOCUMENT_META_ID_FIELD_NAME, (String)id))).setNoFields().setSize(1).execute().actionGet();
        if (searchResponse.getHits().totalHits() == 0L) {
            logger.warn("Going into compatibility mode, looks using passed in ID as the data store id: {}", (Object)id);
            lookupKey = id;
        } else {
            lookupKey = searchResponse.getHits().getHits()[0].getId();
            logger.debug("Translated lookup key for {} is {}.", (Object)id, (Object)lookupKey);
        }
        return this.dataStore.get(fxTable, lookupKey);
    }

    @Override
    public List<Document> getAll(String table, List<String> ids) throws FoxtrotException {
        return this.getAll(table, ids, false);
    }

    @Override
    @Timed
    public List<Document> getAll(String table, List<String> ids, boolean bypassMetalookup) throws FoxtrotException {
        if (!this.tableMetadataManager.exists(table = ElasticsearchUtils.getValidTableName(table))) {
            throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
        }
        LinkedHashMap rowKeys = Maps.newLinkedHashMap();
        for (String id : ids) {
            rowKeys.put(id, id);
        }
        if (!bypassMetalookup) {
            SearchResponse response = (SearchResponse)this.connection.getClient().prepareSearch(new String[]{ElasticsearchUtils.getIndices(table)}).setTypes(new String[]{"document"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)ElasticsearchUtils.DOCUMENT_META_ID_FIELD_NAME, (String[])ids.toArray(new String[ids.size()])))).setFetchSource(false).addField(ElasticsearchUtils.DOCUMENT_META_ID_FIELD_NAME).setSize(ids.size()).execute().actionGet();
            for (SearchHit hit : response.getHits()) {
                String id = ((SearchHitField)hit.getFields().get(ElasticsearchUtils.DOCUMENT_META_ID_FIELD_NAME)).getValue().toString();
                rowKeys.put(id, hit.getId());
            }
        }
        logger.info("Get row keys: {}", (Object)rowKeys.size());
        return this.dataStore.getAll(this.tableMetadataManager.get(table), (List<String>)ImmutableList.copyOf(rowKeys.values()));
    }

    @Override
    public void cleanupAll() throws FoxtrotException {
        Set<String> tables = this.tableMetadataManager.get().stream().map(Table::getName).collect(Collectors.toSet());
        this.cleanup(tables);
    }

    @Override
    @Timed
    public void cleanup(String table) throws FoxtrotException {
        this.cleanup((Set<String>)ImmutableSet.of((Object)table));
    }

    @Override
    @Timed
    public void cleanup(Set<String> tables) throws FoxtrotException {
        ArrayList<String> indicesToDelete = new ArrayList<String>();
        try {
            IndicesStatsResponse response = (IndicesStatsResponse)this.connection.getClient().admin().indices().prepareStats(new String[0]).execute().actionGet();
            Set currentIndices = response.getIndices().keySet();
            for (String currentIndex : currentIndices) {
                String table = ElasticsearchUtils.getTableNameFromIndex(currentIndex);
                if (table == null || !tables.contains(table)) continue;
                try {
                    boolean indexEligibleForDeletion = ElasticsearchUtils.isIndexEligibleForDeletion(currentIndex, this.tableMetadataManager.get(table));
                    if (!indexEligibleForDeletion) continue;
                    logger.warn(String.format("Index eligible for deletion : %s", currentIndex));
                    indicesToDelete.add(currentIndex);
                }
                catch (Exception ex) {
                    logger.error(String.format("Unable to Get Table details for Table : %s", table), (Throwable)ex);
                }
            }
            logger.warn(String.format("Deleting Indexes - Indexes - %s", indicesToDelete));
            if (indicesToDelete.size() > 0) {
                List subLists = Lists.partition(indicesToDelete, (int)5);
                for (List subList : subLists) {
                    try {
                        this.connection.getClient().admin().indices().prepareDelete(subList.toArray(new String[subList.size()])).execute().actionGet(TimeValue.timeValueMinutes((long)5L));
                        logger.warn(String.format("Deleted Indexes - Indexes - %s", subList));
                    }
                    catch (Exception e) {
                        logger.error(String.format("Index deletion failed - Indexes - %s", subList), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw FoxtrotExceptions.createDataCleanupException(String.format("Index Deletion Failed indexes - %s", indicesToDelete), e);
        }
    }

    @Override
    public ClusterHealthResponse getClusterHealth() throws ExecutionException, InterruptedException {
        return (ClusterHealthResponse)this.connection.getClient().admin().cluster().prepareHealth(new String[0]).execute().get();
    }

    @Override
    public NodesStatsResponse getNodeStats() throws ExecutionException, InterruptedException {
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest();
        nodesStatsRequest.clear().jvm(true).os(true).fs(true).indices(true).process(true).breaker(true);
        return (NodesStatsResponse)this.connection.getClient().admin().cluster().nodesStats(nodesStatsRequest).actionGet();
    }

    @Override
    public IndicesStatsResponse getIndicesStats() throws ExecutionException, InterruptedException {
        return (IndicesStatsResponse)this.connection.getClient().admin().indices().prepareStats(new String[]{ElasticsearchUtils.getAllIndicesPattern()}).clear().setDocs(true).setStore(true).execute().get();
    }

    @Override
    public TableFieldMapping getFieldMappings(String table) throws FoxtrotException {
        return this.tableMetadataManager.getFieldMappings(table, false, false);
    }

    private String convert(Document translatedDocument) {
        JsonNode metaNode = this.mapper.valueToTree((Object)translatedDocument.getMetadata());
        ObjectNode dataNode = (ObjectNode)translatedDocument.getData().deepCopy();
        dataNode.set("__FOXTROT_METADATA__", metaNode);
        return dataNode.toString();
    }

    public ElasticsearchConnection getConnection() {
        return this.connection;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public TableMetadataManager getTableMetadataManager() {
        return this.tableMetadataManager;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public CardinalityConfig getCardinalityConfig() {
        return this.cardinalityConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchQueryStore)) {
            return false;
        }
        ElasticsearchQueryStore other = (ElasticsearchQueryStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ElasticsearchConnection this$connection = this.getConnection();
        ElasticsearchConnection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        DataStore this$dataStore = this.getDataStore();
        DataStore other$dataStore = other.getDataStore();
        if (this$dataStore == null ? other$dataStore != null : !this$dataStore.equals(other$dataStore)) {
            return false;
        }
        TableMetadataManager this$tableMetadataManager = this.getTableMetadataManager();
        TableMetadataManager other$tableMetadataManager = other.getTableMetadataManager();
        if (this$tableMetadataManager == null ? other$tableMetadataManager != null : !this$tableMetadataManager.equals(other$tableMetadataManager)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        CardinalityConfig this$cardinalityConfig = this.getCardinalityConfig();
        CardinalityConfig other$cardinalityConfig = other.getCardinalityConfig();
        return !(this$cardinalityConfig == null ? other$cardinalityConfig != null : !((Object)this$cardinalityConfig).equals(other$cardinalityConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchQueryStore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElasticsearchConnection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        DataStore $dataStore = this.getDataStore();
        result = result * 59 + ($dataStore == null ? 43 : $dataStore.hashCode());
        TableMetadataManager $tableMetadataManager = this.getTableMetadataManager();
        result = result * 59 + ($tableMetadataManager == null ? 43 : $tableMetadataManager.hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        CardinalityConfig $cardinalityConfig = this.getCardinalityConfig();
        result = result * 59 + ($cardinalityConfig == null ? 43 : ((Object)$cardinalityConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchQueryStore(connection=" + this.getConnection() + ", dataStore=" + this.getDataStore() + ", tableMetadataManager=" + this.getTableMetadataManager() + ", mapper=" + this.getMapper() + ", cardinalityConfig=" + this.getCardinalityConfig() + ")";
    }
}

