/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.ActionValidationResponse;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.common.AsyncDataToken;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import java.util.concurrent.ExecutorService;

public class QueryExecutor {
    private final AnalyticsLoader analyticsLoader;
    private final ExecutorService executorService;

    public QueryExecutor(AnalyticsLoader analyticsLoader, ExecutorService executorService) {
        this.analyticsLoader = analyticsLoader;
        this.executorService = executorService;
    }

    public <T extends ActionRequest> ActionValidationResponse validate(T request) throws FoxtrotException {
        return this.resolve(request).validate();
    }

    public <T extends ActionRequest> ActionResponse execute(T request) throws FoxtrotException {
        return this.resolve(request).execute();
    }

    public <T extends ActionRequest> AsyncDataToken executeAsync(T request) throws FoxtrotException {
        return this.resolve(request).execute(this.executorService);
    }

    public <T extends ActionRequest> Action resolve(T request) throws FoxtrotException {
        Action<T> action;
        try {
            action = this.analyticsLoader.getAction(request);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.createActionResolutionException(request, e);
        }
        if (null == action) {
            throw FoxtrotExceptions.createUnresolvableActionException(request);
        }
        return action;
    }
}

