/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.ActionValidationResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.general.AnyFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.Cache;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.AsyncDataToken;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.util.MetricUtil;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Action<ParameterType extends ActionRequest>
implements Callable<String> {
    private static final Logger logger = LoggerFactory.getLogger((String)Action.class.getSimpleName());
    private ParameterType parameter;
    private DataStore dataStore;
    private ElasticsearchConnection connection;
    private final TableMetadataManager tableMetadataManager;
    private final QueryStore queryStore;
    private final String cacheToken;
    private final CacheManager cacheManager;
    private final ObjectMapper objectMapper;

    protected Action(ParameterType parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        this.parameter = parameter;
        this.tableMetadataManager = tableMetadataManager;
        this.queryStore = queryStore;
        this.cacheToken = cacheToken;
        this.cacheManager = cacheManager;
        this.connection = connection;
        this.dataStore = dataStore;
        this.objectMapper = objectMapper;
    }

    public String cacheKey() {
        return String.format("%s-%d", this.getRequestCacheKey(), System.currentTimeMillis() / 30000L);
    }

    public AsyncDataToken execute(ExecutorService executor) throws FoxtrotException {
        this.preProcessRequest();
        executor.submit(this);
        return new AsyncDataToken(this.cacheToken, this.cacheKey());
    }

    private void preProcessRequest() throws MalformedQueryException {
        if (this.parameter.getFilters() == null) {
            this.parameter.setFilters((List)Lists.newArrayList((Object[])new Filter[]{new AnyFilter()}));
        }
        this.preprocess();
        this.parameter.setFilters(this.checkAndAddTemporalBoundary(this.parameter.getFilters()));
        this.validateBase(this.parameter);
        this.validateImpl(this.parameter);
    }

    protected abstract void preprocess();

    @Override
    public String call() throws Exception {
        String cacheKey = this.cacheKey();
        this.cacheManager.getCacheFor(this.cacheToken).put(cacheKey, this.execute(this.parameter));
        return cacheKey;
    }

    public ActionValidationResponse validate() {
        try {
            this.preProcessRequest();
        }
        catch (MalformedQueryException e) {
            return ActionValidationResponse.builder().processedRequest(this.parameter).validationErrors(e.getReasons()).build();
        }
        catch (Exception e) {
            return ActionValidationResponse.builder().processedRequest(this.parameter).validationErrors(Collections.singletonList(e.getMessage())).build();
        }
        return ActionValidationResponse.builder().processedRequest(this.parameter).validationErrors(Collections.emptyList()).build();
    }

    public ActionResponse execute() throws FoxtrotException {
        this.preProcessRequest();
        ActionResponse cachedData = this.readCachedData();
        if (cachedData != null) {
            return cachedData;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ActionResponse result = this.execute(this.parameter);
            MetricUtil.getInstance().registerActionSuccess(this.cacheToken, this.getMetricKey(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.updateCachedData(result);
            return result;
        }
        catch (FoxtrotException e) {
            stopwatch.stop();
            MetricUtil.getInstance().registerActionFailure(this.cacheToken, this.getMetricKey(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw e;
        }
    }

    public long getGetQueryTimeout() {
        if (this.getConnection().getConfig() == null) {
            return 10000L;
        }
        return this.getConnection().getConfig().getGetQueryTimeout();
    }

    private void updateCachedData(ActionResponse result) {
        Cache cache = this.cacheManager.getCacheFor(this.cacheToken);
        if (this.isCacheable()) {
            cache.put(this.cacheKey(), result);
        }
    }

    protected ActionResponse readCachedData() {
        Cache cache = this.cacheManager.getCacheFor(this.cacheToken);
        String cacheKeyValue = this.cacheKey();
        if (this.isCacheable()) {
            if (cache.has(cacheKeyValue)) {
                MetricUtil.getInstance().registerActionCacheHit(this.cacheToken, this.getMetricKey());
                logger.info("Cache hit for key: " + cacheKeyValue);
                return cache.get(this.cacheKey());
            }
            MetricUtil.getInstance().registerActionCacheMiss(this.cacheToken, this.getMetricKey());
            logger.info("Cache miss for key: " + cacheKeyValue);
        }
        return null;
    }

    private void validateBase(ParameterType parameter) throws MalformedQueryException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!CollectionUtils.isNullOrEmpty((Collection)parameter.getFilters())) {
            for (Filter filter : parameter.getFilters()) {
                Set errors = filter.validate();
                if (CollectionUtils.isNullOrEmpty((Collection)errors)) continue;
                validationErrors.addAll(errors);
            }
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException(parameter, validationErrors);
        }
    }

    public abstract String getMetricKey();

    protected abstract String getRequestCacheKey();

    public abstract void validateImpl(ParameterType var1) throws MalformedQueryException;

    public abstract ActionResponse execute(ParameterType var1) throws FoxtrotException;

    protected ParameterType getParameter() {
        return this.parameter;
    }

    public final boolean isCacheable() {
        return this.cacheManager.getCacheFor(this.cacheToken) != null;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public ElasticsearchConnection getConnection() {
        return this.connection;
    }

    public TableMetadataManager getTableMetadataManager() {
        return this.tableMetadataManager;
    }

    public QueryStore getQueryStore() {
        return this.queryStore;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected Filter getDefaultTimeSpan() {
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        return lessThanFilter;
    }

    private List<Filter> checkAndAddTemporalBoundary(List<Filter> filters) {
        if (null != filters) {
            for (Filter filter : filters) {
                if (!filter.isFilterTemporal()) continue;
                return filters;
            }
        }
        filters = null == filters ? Lists.newArrayList() : Lists.newArrayList((Iterable)filters);
        filters.add(this.getDefaultTimeSpan());
        return filters;
    }
}

