/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseConfig;
import com.flipkart.foxtrot.core.querystore.DocumentTranslator;
import com.flipkart.foxtrot.core.querystore.actions.Constants;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class DocumentTranslatorTest {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRawKeyVersion() {
        HbaseConfig hbaseConfig = new HbaseConfig();
        hbaseConfig.setRawKeyVersion(UUID.randomUUID().toString());
        new DocumentTranslator(hbaseConfig);
    }

    @Test
    public void testTranslationWithNullRawKeyVersion() {
        HbaseConfig hbaseConfig = new HbaseConfig();
        hbaseConfig.setRawKeyVersion(null);
        DocumentTranslator translator = new DocumentTranslator(hbaseConfig);
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        document.setData((JsonNode)mapper.createObjectNode().put("name", "rishabh"));
        Document translatedDocument = translator.translate(table, document);
        Assert.assertEquals((Object)translatedDocument.getId(), (Object)document.getId());
        Assert.assertNotNull((Object)translatedDocument.getMetadata());
        Assert.assertEquals((Object)translatedDocument.getMetadata().getId(), (Object)document.getId());
        Assert.assertEquals((Object)translatedDocument.getMetadata().getRawStorageId(), (Object)(document.getId() + ":" + table.getName()));
    }

    @Test
    public void testTranslationWithRawKeyVersion1() {
        DocumentTranslator translator = new DocumentTranslator(TestUtils.createHBaseConfigWithRawKeyV1());
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        document.setData((JsonNode)mapper.createObjectNode().put("name", "rishabh"));
        Document translatedDocument = translator.translate(table, document);
        Assert.assertEquals((Object)translatedDocument.getId(), (Object)document.getId());
        Assert.assertNotNull((Object)translatedDocument.getMetadata());
        Assert.assertEquals((Object)translatedDocument.getMetadata().getId(), (Object)document.getId());
        Assert.assertEquals((Object)translatedDocument.getMetadata().getRawStorageId(), (Object)(document.getId() + ":" + table.getName()));
    }

    @Test
    public void testTranslationWithRawKeyVersion2() {
        DocumentTranslator translator = new DocumentTranslator(TestUtils.createHBaseConfigWithRawKeyV2());
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        document.setData((JsonNode)mapper.createObjectNode().put("name", "rishabh"));
        Document translatedDocument = translator.translate(table, document);
        Assert.assertNotNull((Object)translatedDocument.getMetadata());
        Assert.assertEquals((Object)translatedDocument.getId(), (Object)translatedDocument.getMetadata().getRawStorageId());
        Assert.assertEquals((Object)translatedDocument.getMetadata().getId(), (Object)document.getId());
        Assert.assertTrue((boolean)translatedDocument.getMetadata().getRawStorageId().endsWith((String)Constants.rawKeyVersionToSuffixMap.get("2.0")));
    }

    @Test
    public void testTranslationBackWithRawKeyVersion1() {
        DocumentTranslator translator = new DocumentTranslator(TestUtils.createHBaseConfigWithRawKeyV1());
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        document.setData((JsonNode)mapper.createObjectNode().put("name", "rishabh"));
        Document translatedDocument = translator.translate(table, document);
        Document translatedBackDocument = translator.translateBack(translatedDocument);
        Assert.assertEquals((Object)document.getId(), (Object)translatedBackDocument.getId());
        Assert.assertEquals((long)document.getTimestamp(), (long)translatedBackDocument.getTimestamp());
    }

    @Test
    public void testTranslationBackWithRawKeyVersion2() {
        HbaseConfig hbaseConfig = new HbaseConfig();
        hbaseConfig.setRawKeyVersion("2.0");
        DocumentTranslator translator = new DocumentTranslator(hbaseConfig);
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setTimestamp(System.currentTimeMillis());
        document.setData((JsonNode)mapper.createObjectNode().put("name", "rishabh"));
        Document translatedDocument = translator.translate(table, document);
        Document translatedBackDocument = translator.translateBack(translatedDocument);
        Assert.assertEquals((Object)document.getId(), (Object)translatedBackDocument.getId());
        Assert.assertEquals((long)document.getTimestamp(), (long)translatedBackDocument.getTimestamp());
    }
}

