/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.query.numeric;

import com.flipkart.foxtrot.common.query.Filter;
import java.util.Set;
import javax.validation.constraints.NotNull;

public abstract class NumericBinaryFilter
extends Filter {
    @NotNull
    private Number value;
    private boolean temporal = false;

    protected NumericBinaryFilter(String operator) {
        super(operator);
    }

    protected NumericBinaryFilter(String operator, String field, Number value, boolean temporal) {
        super(operator, field);
        this.value = value;
        this.temporal = temporal;
    }

    @Override
    public boolean isFilterTemporal() {
        return this.temporal;
    }

    @Override
    public Set<String> validate() {
        Set<String> validationErrors = super.validate();
        if (this.value == null) {
            validationErrors.add("filter value cannot be null");
        }
        return validationErrors;
    }

    public Number getValue() {
        return this.value;
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public void setTemporal(boolean temporal) {
        this.temporal = temporal;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericBinaryFilter)) {
            return false;
        }
        NumericBinaryFilter other = (NumericBinaryFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Number this$value = this.getValue();
        Number other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isTemporal() == other.isTemporal();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NumericBinaryFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Number $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isTemporal() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "NumericBinaryFilter(super=" + super.toString() + ", value=" + this.getValue() + ", temporal=" + this.isTemporal() + ")";
    }
}

